clear
% 
% EXAMPLE OF USE
%
%  [SSH,SSH_BCC,SSH_FCC,matrixDelta] = computeSSH_V4(ElementsName,composition,CrystalStructure)

%   OUT:
%      ElementsName 
%      composition  in at.
%      Crystal structure  'FCC' or 'BCC'
%   OUTPUT:
%      SSH          Solid solution hardening effect (MPa) for the  CrystalStructure input
%      SSH_BCC      Solid solution hardening effect (MPa) if  the  CrystalStructure were BCC
%      SSH_FCC      Solid solution hardening effect (MPa) if  the  CrystalStructure were FCC
%      matrixDelta  Matrix at Eq (11) of the scripta paper.

[SSH,~,~,~] = computeSSH_V4({'Fe','Co','Ni','Cr','Al'},[0.2,0.2,0.2,0.2,0.2],'FCC');
%
% COMMENTS
%
fprintf('\n SSH = %4.1f (MPa)\n',SSH);