function [s_Matrix,s_Force,s_Lattice,a_Matrix,a_Force,a_Lattice,a_Elements,K_Matrix,K_Force,K_Lattice] = computeS_V3(ElementsName,composition,caseStructure)

nElements = length(ElementsName);
X = composition/sum(composition);
a_Matrix = zeros(nElements,nElements);
K_Matrix = zeros(nElements,nElements);
a_Force = zeros(nElements,nElements);
K_Force = zeros(nElements,nElements);
%
% COMPUTE THE CELL PARAMETERS, CONPACT AND NO COMPACT INTERATOMIC SPACINGS
%
%
a            = data_CellParameter(ElementsName);
CS           = data_CrystalStructure(ElementsName);
s_Compact    = zeros(1,nElements);
s_NoCompact  = zeros(1,nElements);
for nE=1:nElements
    if( strcmp(CS{nE},'BCC'))
        s_NoCompact(nE) = a(nE,1)*sqrt(3)/2;
        s_Compact(nE)   = s_NoCompact(nE)/0.975;
    elseif( strcmp(CS{nE},'FCC'))
        s_Compact(nE)   = a(nE,1)*sqrt(2)/2;
        s_NoCompact(nE) =  s_Compact(nE) *0.975;
    elseif( strcmp(CS{nE},'HCP'))
        s_Compact(nE)   = (a(nE,1)^2*a(nE,3))^(1/3) * 3^(1/6) * sqrt(2)/2;
        s_NoCompact(nE) =  s_Compact(nE)*.975;
    elseif( strcmp(CS{nE},'Tetrahedral Packing'))
        s_Compact(nE)   = a(nE,1)*sqrt(3)/4;
        s_NoCompact(nE) =  s_Compact(nE)*.975;
    elseif( strcmp(CS{nE},'Centered Tetragonal'))
        s_NoCompact(nE) =  sqrt(a(nE,1)^2 + a(nE,2)^2  + a(nE,3)^2)/2;
        s_Compact(nE)   = s_NoCompact(nE)/0.975;
    elseif( strcmp(CS{nE},'Simple Trigonal'))
        s_NoCompact(nE) =  a(nE,1);
        s_Compact(nE)   = s_NoCompact(nE)/0.975;
    elseif( strcmp(CS{nE},'Base Centered Orthorhombic'))
        if( strcmp(ElementsName{nE},'Ga'))
            s_Compact(nE)   = 1/2* sqrt(a(nE,1)^2 + a(nE,2)^2 ) + ...
                1/2* sqrt(a(nE,1)^2 + a(nE,3)^2 ) + ...
                1/2* sqrt(a(nE,3)^2 + a(nE,3)^2 );
            s_Compact(nE) =  s_Compact(nE)/3;
            s_NoCompact(nE) =  s_Compact(nE)*.975;
        else
            1
        end
    elseif( strcmp(CS{nE},'Simple Triclinic'))
        if( strcmp(ElementsName{nE},'P'))
            s_Compact(nE)   = 1/2* sqrt(a(nE,1)^2 + a(nE,2)^2 ) + ...
                1/2* sqrt(a(nE,1)^2 + a(nE,3)^2 ) + ...
                1/2* sqrt(a(nE,3)^2 + a(nE,3)^2 );
            s_Compact(nE) =  s_Compact(nE)/3;
            s_NoCompact(nE) =  s_Compact(nE)*.975;
        else
            1
        end
    else
        1
    end
end
K            = data_BulkModulus(ElementsName);



 


if(strcmp(caseStructure,'FCC'))
    a = s_Compact*2/sqrt(2);
elseif(strcmp(caseStructure,'BCC'))
    a = s_NoCompact*2/sqrt(3);
end
a_Elements = a;

a_Lattice = sum(a.^2.*K.*X)/sum(a.*K.*X);
K_Lattice = sum(a.*K.*X)^2/sum(a.^2.*K.*X);

for i = 1:nElements
    for j=1:nElements
        aij = sum(a([i,j]).^2.*K([i,j]))/sum(a([i,j]).*K([i,j]));
        Kij = sum(a([i,j]).*K([i,j]))^2/sum(a([i,j]).^2.*K([i,j]))/2;
        a_Force(i,j) = aij;
        K_Force(i,j) = Kij;
        a_Matrix(i,j) = (Kij*aij^2 + K_Lattice*a_Lattice^2)/ (Kij*aij + K_Lattice*a_Lattice);
        K_Matrix(i,j) = (Kij*aij + K_Lattice*a_Lattice)^2/(Kij*aij^2 + K_Lattice*a_Lattice^2)/2;
    end
end
if(strcmp('BCC',caseStructure))
    s_Matrix = a_Matrix*sqrt(3)/2;
    s_Force  = a_Force*sqrt(3)/2;
    s_Lattice = a_Lattice*sqrt(3)/2;
elseif(strcmp('FCC',caseStructure))
    s_Matrix = a_Matrix*sqrt(2)/2;
    s_Force  =  a_Force*sqrt(2)/2;
    s_Lattice = a_Lattice*sqrt(2)/2;
end

% s_Ave = 0;
% K_Ave = 0;
% for i=1:nElements
%     for j=1:nElements
%         s_Ave = s_Ave + s_Matrix(i,j)*X(i)*X(j);
%         K_Ave = K_Ave + K_Matrix(i,j)*X(i)*X(j);
%     end
% end
%
% a_Ave = s_Ave*2/sqrt(3);
% a_Ave = a_Lattice;



