function [ dataOutput]= data_ShearModulus(ElementsName)

ElementsSymbol = {'Al';
'Sb';
'Ba';
'Be';
'Bi';
'B';
'Cd';
'Ca';
'Ce';
'Cr';
'Co';
'Cu';
'Dy';
'Er';
'Eu';
'Gd';
'Ga';
'Ge';
'Au';
'Hf';
'Ho';
'In';
'Ir';
'Fe';
'La';
'Pb';
'Li';
'Lu';
'Mg';
'Mn';
'Mo';
'Nd';
'Ni';
'Nb';
'Os';
'Pd';
'Pt';
'Pu';
'K';
'Pr';
'Pm';
'Re';
'Rh';
'Ru';
'Sm';
'Sc';
'Se';
'Si';
'Ag';
'Na';
'Sr';
'Ta';
'Te';
'Tb';
'Tl';
'Th';
'Tm';
'Sn';
'Ti';
'W';
'U';
'V';
'Yb';
'Y';
'Zn';
'Zr';
};

%	Shear Modulus
Elements_Data = [26
20
4.9
132
12
207
19
7.4
14
115
75
48
25
28
7.9
22
6.7
40
27
30
26
3.8
210
82
14
5.6
4.2
27
17
78
118
16
76
38
222
44
61
43
1.3
15
18
178
150
173
20
29
3.7
40.5
30
3.3
6.1
69
16
22
2.8
31
31
18
44
161
111
47
9.9
26
43
33];


atomicNumber = zeros(length(ElementsName),1);
for nE=1:length(ElementsName)
    ElementNameThis = ElementsName{nE};
    for nEL = 1:length(ElementsSymbol)
        answer = strncmp(ElementNameThis,ElementsSymbol{nEL},length(ElementNameThis));
        if(answer && length(ElementNameThis)==length(ElementsSymbol{nEL}))
           atomicNumber(nE,1) = nEL;
           
        break;
        end
    end
end

for nA=1:length(atomicNumber) 
    if(isnumeric(atomicNumber(nA)) && atomicNumber(nA)>0)
        dataOutput(nA) = Elements_Data(atomicNumber(nA),1);
    else
       
        dataOutput(nA) = (3*data_BulkModulus({ElementsName{nA}})*(1-2*data_PoissonRatio({ElementsName{nA}}))) /    (2*( 1 + data_PoissonRatio({ElementsName{nA}})));

    end
end



           