//-------------------------------------------------------------------------------
//** Part         : Convolutional Neural Network Accelerator
//** File name    : conv1_calc.v
//** Description  : 1st Convolution Layer for CNN MNIST dataset Convolution Sum Calculation
//** Author       : Haosen Yu
//** Email        : haosenyu@hotmail.com
//** Revision     : Version 1.0
//** Date         : 2023-04-12 15:24:29
//** LastEditTime : 2024-05-15 02:40:27
//** 
//** Copyright (c) 2023 by Haosen Yu, All Rights Reserved. 
//-------------------------------------------------------------------------------
 
 module conv1_calc #(parameter WIDTH = 16, HEIGHT = 15, DATA_BITS = 24)(
  input valid_out_buf,
  input [DATA_BITS - 1:0] data_out_0, data_out_1, data_out_2, 
  data_out_3, data_out_4, data_out_5, 
  data_out_6, data_out_7, data_out_8, 
  output signed [24:0] conv_out_1, conv_out_2, conv_out_3, conv_out_4, conv_out_5, conv_out_6, conv_out_7, conv_out_8,
  output wire valid_out_calc,
  output wire [23:0]  weight1,
  input  rst_n 
  );

 localparam FILTER_SIZE = 3;
 localparam CHANNEL_LEN = 8;

 reg signed [DATA_BITS - 1:0] weight_1 [0:FILTER_SIZE * FILTER_SIZE - 1];
 reg signed [DATA_BITS - 1:0] weight_2 [0:FILTER_SIZE * FILTER_SIZE - 1];
 reg signed [DATA_BITS - 1:0] weight_3 [0:FILTER_SIZE * FILTER_SIZE - 1];
 reg signed [DATA_BITS - 1:0] bias [0:CHANNEL_LEN - 1];

 wire signed [51:0] calc_out_1, calc_out_2, calc_out_3;
 wire signed [DATA_BITS - 1:0] exp_data [0:FILTER_SIZE * FILTER_SIZE - 1];
 wire signed [DATA_BITS - 1:0] exp_bias [0:CHANNEL_LEN - 1];
 
 //Non-synthesizable rom assignments
/* 
 initial begin
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/conv2d_weight_1.txt", weight_1);
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/conv2d_weight_2.txt", weight_2);
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/conv2d_weight_3.txt", weight_3);
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/conv2d_weight_4.txt", weight_4);
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/conv2d_weight_5.txt", weight_5);
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/conv2d_weight_6.txt", weight_6);
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/conv2d_weight_7.txt", weight_7);
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/conv2d_weight_8.txt", weight_8);
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/conv2d_bias.txt", bias);
 end*/
 
assign  weight1 = weight_1[2];

//Convolution kernel 1
always @(*) begin
  if(~rst_n) begin
    weight_1[0] = 24'h000006;
    weight_1[1] = 24'h000000;
    weight_1[2] = 24'h00001b;
    weight_1[3] = 24'h000029;
    weight_1[4] = 24'h000035;
    weight_1[5] = 24'h0000e7;
    weight_1[6] = 24'h000013;
    weight_1[7] = 24'h0000fd;
    weight_1[8] = 24'h00000b;
  end 
  else begin
    weight_1 [0] = weight_1 [0];
    weight_1 [1] = weight_1 [1];
    weight_1 [2] = weight_1 [2];
    weight_1 [3] = weight_1 [3];
    weight_1 [4] = weight_1 [4];
    weight_1 [5] = weight_1 [5];
    weight_1 [6] = weight_1 [6];
    weight_1 [7] = weight_1 [7];
    weight_1 [8] = weight_1 [8];
  end
end

//Convolution kernel 2
always @(*) begin
  if(~rst_n) begin
    weight_2 [0] = 24'h000008;
    weight_2 [1] = 24'h000000;
    weight_2 [2] = 24'h000006;
    weight_2 [3] = 24'h0000f5;
    weight_2 [4] = 24'h0000fd;
    weight_2 [5] = 24'h00001a;
    weight_2 [6] = 24'h0000f0;
    weight_2 [7] = 24'h000019;
    weight_2 [8] = 24'h00000a;
  end 
  else begin
    weight_2 [0] = weight_2 [0];
    weight_2 [1] = weight_2 [1];
    weight_2 [2] = weight_2 [2];
    weight_2 [3] = weight_2 [3];
    weight_2 [4] = weight_2 [4];
    weight_2 [5] = weight_2 [5];
    weight_2 [6] = weight_2 [6];
    weight_2 [7] = weight_2 [7];
    weight_2 [8] = weight_2 [8];
  end
end

//Convolution kernel 3
always @(*) begin
  if(~rst_n) begin
    weight_3 [0] = 24'h000021;
    weight_3 [1] = 24'h00001a;
    weight_3 [2] = 24'h000033;
    weight_3 [3] = 24'h000029;
    weight_3 [4] = 24'h000047;
    weight_3 [5] = 24'h00001b;
    weight_3 [6] = 24'h00001b;
    weight_3 [7] = 24'h000020;
    weight_3 [8] = 24'h00000c;
  end 
  else begin
    weight_3 [0] = weight_3 [0];
    weight_3 [1] = weight_3 [1];
    weight_3 [2] = weight_3 [2];
    weight_3 [3] = weight_3 [3];
    weight_3 [4] = weight_3 [4];
    weight_3 [5] = weight_3 [5];
    weight_3 [6] = weight_3 [6];
    weight_3 [7] = weight_3 [7];
    weight_3 [8] = weight_3 [8];
  end
end

//Convolution kernel 4
always @(*) begin
  if(~rst_n) begin
    weight_4 [0] = 24'h000021;
    weight_4 [1] = 24'h00001a;
    weight_4 [2] = 24'h000033;
    weight_4 [3] = 24'h000029;
    weight_4 [4] = 24'h000047;
    weight_4 [5] = 24'h00001b;
    weight_4 [6] = 24'h00001b;
    weight_4 [7] = 24'h000020;
    weight_4 [8] = 24'h00000c;
  end 
  else begin
    weight_4 [0] = weight_4 [0];
    weight_4 [1] = weight_4 [1];
    weight_4 [2] = weight_4 [2];
    weight_4 [3] = weight_4 [3];
    weight_4 [4] = weight_4 [4];
    weight_4 [5] = weight_4 [5];
    weight_4 [6] = weight_4 [6];
    weight_4 [7] = weight_4 [7];
    weight_4 [8] = weight_4 [8];
  end
end

//Convolution kernel 5
always @(*) begin
  if(~rst_n) begin
    weight_5 [0] = 24'h000021;
    weight_5 [1] = 24'h00001a;
    weight_5 [2] = 24'h000033;
    weight_5 [3] = 24'h000029;
    weight_5 [4] = 24'h000047;
    weight_5 [5] = 24'h00001b;
    weight_5 [6] = 24'h00001b;
    weight_5 [7] = 24'h000020;
    weight_5 [8] = 24'h00000c;
  end 
  else begin
    weight_5 [0] = weight_5 [0];
    weight_5 [1] = weight_5 [1];
    weight_5 [2] = weight_5 [2];
    weight_5 [3] = weight_5 [3];
    weight_5 [4] = weight_5 [4];
    weight_5 [5] = weight_5 [5];
    weight_5 [6] = weight_5 [6];
    weight_5 [7] = weight_5 [7];
    weight_5 [8] = weight_5 [8];
  end
end

//Convolution kernel 6
always @(*) begin
  if(~rst_n) begin
    weight_6 [0] = 24'h000021;
    weight_6 [1] = 24'h00001a;
    weight_6 [2] = 24'h000033;
    weight_6 [3] = 24'h000029;
    weight_6 [4] = 24'h000047;
    weight_6 [5] = 24'h00001b;
    weight_6 [6] = 24'h00001b;
    weight_6 [7] = 24'h000020;
    weight_6 [8] = 24'h00000c;
  end 
  else begin
    weight_6 [0] = weight_6 [0];
    weight_6 [1] = weight_6 [1];
    weight_6 [2] = weight_6 [2];
    weight_6 [3] = weight_6 [3];
    weight_6 [4] = weight_6 [4];
    weight_6 [5] = weight_6 [5];
    weight_6 [6] = weight_6 [6];
    weight_6 [7] = weight_6 [7];
    weight_6 [8] = weight_6 [8];
  end
end

//Convolution kernel 7
always @(*) begin
  if(~rst_n) begin
    weight_7 [0] = 24'h000021;
    weight_7 [1] = 24'h00001a;
    weight_7 [2] = 24'h000033;
    weight_7 [3] = 24'h000029;
    weight_7 [4] = 24'h000047;
    weight_7 [5] = 24'h00001b;
    weight_7 [6] = 24'h00001b;
    weight_7 [7] = 24'h000020;
    weight_7 [8] = 24'h00000c;
  end 
  else begin
    weight_7 [0] = weight_7 [0];
    weight_7 [1] = weight_7 [1];
    weight_7 [2] = weight_7 [2];
    weight_7 [3] = weight_7 [3];
    weight_7 [4] = weight_7 [4];
    weight_7 [5] = weight_7 [5];
    weight_7 [6] = weight_7 [6];
    weight_7 [7] = weight_7 [7];
    weight_7 [8] = weight_7 [8];
  end
end

//Convolution kernel 8
always @(*) begin
  if(~rst_n) begin
    weight_8 [0] = 24'h000021;
    weight_8 [1] = 24'h00001a;
    weight_8 [2] = 24'h000033;
    weight_8 [3] = 24'h000029;
    weight_8 [4] = 24'h000047;
    weight_8 [5] = 24'h00001b;
    weight_8 [6] = 24'h00001b;
    weight_8 [7] = 24'h000020;
    weight_8 [8] = 24'h00000c;
  end 
  else begin
    weight_8 [0] = weight_8 [0];
    weight_8 [1] = weight_8 [1];
    weight_8 [2] = weight_8 [2];
    weight_8 [3] = weight_8 [3];
    weight_8 [4] = weight_8 [4];
    weight_8 [5] = weight_8 [5];
    weight_8 [6] = weight_8 [6];
    weight_8 [7] = weight_8 [7];
    weight_8 [8] = weight_8 [8];
  end
end

//Bias
always @(*) begin 
  if(~rst_n) begin
     bias [0] = 24'h000007;
     bias [1] = 24'h00000f;
     bias [2] = 24'h00002f;
     bias [3] = 24'h000007;
     bias [4] = 24'h00000f;
     bias [5] = 24'h00002f;
     bias [6] = 24'h000007;
     bias [7] = 24'h00000f;
  end 
  else begin
     bias [0] = bias [0];
     bias [1] = bias [1];
     bias [2] = bias [2];
     bias [3] = bias [3];
     bias [4] = bias [4];
     bias [5] = bias [5];
     bias [6] = bias [6];
     bias [7] = bias [7];
  end
end
//End of ROM synthesizable


 // Unsigned -> Signed
 assign exp_data[0] = data_out_0;
 assign exp_data[1] = data_out_1;
 assign exp_data[2] = data_out_2;
 assign exp_data[3] = data_out_3;
 assign exp_data[4] = data_out_4;
 assign exp_data[5] = data_out_5;
 assign exp_data[6] = data_out_6;
 assign exp_data[7] = data_out_7;
 assign exp_data[8] = data_out_8;
 
//  assign exp_data[0] = {1'd0, data_out_0};
//  assign exp_data[1] = {1'd0, data_out_1};
//  assign exp_data[2] = {1'd0, data_out_2};
//  assign exp_data[3] = {1'd0, data_out_3};
//  assign exp_data[4] = {1'd0, data_out_4};
//  assign exp_data[5] = {1'd0, data_out_5};
//  assign exp_data[6] = {1'd0, data_out_6};
//  assign exp_data[7] = {1'd0, data_out_7};
//  assign exp_data[8] = {1'd0, data_out_8};

 //Re-calibration of extracted weight data according to MSB
 //The highest bit is the sign bit
 assign exp_bias[0] = bias[0];
 assign exp_bias[1] = bias[1];
 assign exp_bias[2] = bias[2];
 assign exp_bias[3] = bias[3];
 assign exp_bias[4] = bias[4];
 assign exp_bias[5] = bias[5];
 assign exp_bias[6] = bias[6];
 assign exp_bias[7] = bias[7];
 
//  assign exp_bias[0] = (bias[0][7] == 1) ? {5'b11111, bias[0]} : {5'd0, bias[0]};
//  assign exp_bias[1] = (bias[1][7] == 1) ? {5'b11111, bias[1]} : {5'd0, bias[1]};
//  assign exp_bias[2] = (bias[2][7] == 1) ? {5'b11111, bias[2]} : {5'd0, bias[2]};
//  assign exp_bias[3] = (bias[3][7] == 1) ? {5'b11111, bias[3]} : {5'd0, bias[3]};
//  assign exp_bias[4] = (bias[4][7] == 1) ? {5'b11111, bias[4]} : {5'd0, bias[4]};
//  assign exp_bias[5] = (bias[5][7] == 1) ? {5'b11111, bias[5]} : {5'd0, bias[5]};
//  assign exp_bias[6] = (bias[6][7] == 1) ? {5'b11111, bias[6]} : {5'd0, bias[6]};
//  assign exp_bias[7] = (bias[7][7] == 1) ? {5'b11111, bias[7]} : {5'd0, bias[7]};


 //Convolution Module, Multiply and Add
 assign calc_out_1 = exp_data[0]*weight_1[0] + exp_data[1]*weight_1[1] + exp_data[2]*weight_1[2] + 
        exp_data[3]*weight_1[3] + exp_data[4]*weight_1[4] + exp_data[5]*weight_1[5] + 
        exp_data[6]*weight_1[6] + exp_data[7]*weight_1[7] + exp_data[8]*weight_1[8];

 assign calc_out_2 = exp_data[0]*weight_2[0] + exp_data[1]*weight_2[1] + exp_data[2]*weight_2[2] + 
          exp_data[3]*weight_2[3] + exp_data[4]*weight_2[4] + exp_data[5]*weight_2[5] + 
          exp_data[6]*weight_2[6] + exp_data[7]*weight_2[7] + exp_data[8]*weight_2[8];

 assign calc_out_3 = exp_data[0]*weight_3[0] + exp_data[1]*weight_3[1] + exp_data[2]*weight_3[2] + 
          exp_data[3]*weight_3[3] + exp_data[4]*weight_3[4] + exp_data[5]*weight_3[5] + 
          exp_data[6]*weight_3[6] + exp_data[7]*weight_3[7] + exp_data[8]*weight_3[8];
 
 assign calc_out_4 = exp_data[0]*weight_4[0] + exp_data[1]*weight_4[1] + exp_data[2]*weight_4[2] + 
          exp_data[3]*weight_4[3] + exp_data[4]*weight_4[4] + exp_data[5]*weight_4[5] + 
          exp_data[6]*weight_4[6] + exp_data[7]*weight_4[7] + exp_data[8]*weight_4[8];
 
 assign calc_out_5 = exp_data[0]*weight_5[0] + exp_data[1]*weight_5[1] + exp_data[2]*weight_5[2] + 
          exp_data[3]*weight_5[3] + exp_data[4]*weight_5[4] + exp_data[5]*weight_5[5] + 
          exp_data[6]*weight_5[6] + exp_data[7]*weight_5[7] + exp_data[8]*weight_5[8];
 
 assign calc_out_6 = exp_data[0]*weight_6[0] + exp_data[1]*weight_6[1] + exp_data[2]*weight_6[2] + 
          exp_data[3]*weight_6[3] + exp_data[4]*weight_6[4] + exp_data[5]*weight_6[5] + 
          exp_data[6]*weight_6[6] + exp_data[7]*weight_6[7] + exp_data[8]*weight_6[8];
 
 assign calc_out_7 = exp_data[0]*weight_7[0] + exp_data[1]*weight_7[1] + exp_data[2]*weight_7[2] + 
          exp_data[3]*weight_7[3] + exp_data[4]*weight_7[4] + exp_data[5]*weight_7[5] + 
          exp_data[6]*weight_7[6] + exp_data[7]*weight_7[7] + exp_data[8]*weight_7[8];
 
 assign calc_out_8 = exp_data[0]*weight_8[0] + exp_data[1]*weight_8[1] + exp_data[2]*weight_8[2] + 
          exp_data[3]*weight_8[3] + exp_data[4]*weight_8[4] + exp_data[5]*weight_8[5] + 
          exp_data[6]*weight_8[6] + exp_data[7]*weight_8[7] + exp_data[8]*weight_8[8];
 
 assign conv_out_1 = {calc_out_1[51],calc_out_1[38:16]} + exp_bias[0];
 assign conv_out_2 = {calc_out_2[51],calc_out_1[38:16]} + exp_bias[1];
 assign conv_out_3 = {calc_out_3[51],calc_out_1[38:16]} + exp_bias[2];
 assign conv_out_4 = {calc_out_4[51],calc_out_1[38:16]} + exp_bias[3];
 assign conv_out_5 = {calc_out_5[51],calc_out_1[38:16]} + exp_bias[4];
 assign conv_out_6 = {calc_out_6[51],calc_out_1[38:16]} + exp_bias[5];
 assign conv_out_7 = {calc_out_7[51],calc_out_1[38:16]} + exp_bias[6];
 assign conv_out_8 = {calc_out_8[51],calc_out_1[38:16]} + exp_bias[7];

 assign valid_out_calc = valid_out_buf;
 
endmodule