//-------------------------------------------------------------------------------
//** Part         : Convolutional Neural Network Accelerator
//** File name    : sigmoid_lut.v
//** Description  : sigmoid layer based on LUT
//** Author       : Haosen Yu
//** Email        : haosenyu@hotmail.com
//** Revision     : Version 1.0
//** Date         : 2023-04-12 15:22:48
//** LastEditTime : 2024-05-15 03:13:04
//** 
//** Copyright (c) 2023 by Haosen Yu, All Rights Reserved. 
//-------------------------------------------------------------------------------

module sigmoid_lut (
    input wire [23:0] index,    // 24位输入索引
    output reg [7:0] sigmoid_value,  // 8位输出Sigmoid值
    output reg       decision
);

    // 定义查找表数据
    reg [7:0] lut [0:1<<24]; // 2^24条数据表示8位输入

    // 在initial块中初始化查找表
    initial begin
        lut[0] = 8'h04;
        lut[1] = 8'h04;
        lut[2] = 8'h04;
        lut[3] = 8'h05;
        lut[4] = 8'h05;
        lut[5] = 8'h05;
        lut[6] = 8'h05;
        lut[7] = 8'h05;
        lut[8] = 8'h05;
        lut[9] = 8'h06;
        lut[10] = 8'h06;
        lut[11] = 8'h06;
        lut[12] = 8'h06;
        lut[13] = 8'h06;
        lut[14] = 8'h07;
        lut[15] = 8'h07;
        lut[16] = 8'h07;
        lut[17] = 8'h07;
        lut[18] = 8'h07;
        lut[19] = 8'h08;
        lut[20] = 8'h08;
        lut[21] = 8'h08;
        lut[22] = 8'h08;
        lut[23] = 8'h09;
        lut[24] = 8'h09;
        lut[25] = 8'h09;
        lut[26] = 8'h0A;
        lut[27] = 8'h0A;
        lut[28] = 8'h0A;
        lut[29] = 8'h0B;
        lut[30] = 8'h0B;
        lut[31] = 8'h0B;
        lut[32] = 8'h0C;
        lut[33] = 8'h0C;
        lut[34] = 8'h0C;
        lut[35] = 8'h0D;
        lut[36] = 8'h0D;
        lut[37] = 8'h0E;
        lut[38] = 8'h0E;
        lut[39] = 8'h0E;
        lut[40] = 8'h0F;
        lut[41] = 8'h0F;
        lut[42] = 8'h10;
        lut[43] = 8'h10;
        lut[44] = 8'h11;
        lut[45] = 8'h11;
        lut[46] = 8'h12;
        lut[47] = 8'h12;
        lut[48] = 8'h13;
        lut[49] = 8'h13;
        lut[50] = 8'h14;
        lut[51] = 8'h15;
        lut[52] = 8'h15;
        lut[53] = 8'h16;
        lut[54] = 8'h16;
        lut[55] = 8'h17;
        lut[56] = 8'h18;
        lut[57] = 8'h19;
        lut[58] = 8'h19;
        lut[59] = 8'h1A;
        lut[60] = 8'h1B;
        lut[61] = 8'h1B;
        lut[62] = 8'h1C;
        lut[63] = 8'h1D;
        lut[64] = 8'h1E;
        lut[65] = 8'h1F;
        lut[66] = 8'h20;
        lut[67] = 8'h20;
        lut[68] = 8'h21;
        lut[69] = 8'h22;
        lut[70] = 8'h23;
        lut[71] = 8'h24;
        lut[72] = 8'h25;
        lut[73] = 8'h26;
        lut[74] = 8'h27;
        lut[75] = 8'h28;
        lut[76] = 8'h29;
        lut[77] = 8'h2B;
        lut[78] = 8'h2C;
        lut[79] = 8'h2D;
        lut[80] = 8'h2E;
        lut[81] = 8'h2F;
        lut[82] = 8'h30;
        lut[83] = 8'h32;
        lut[84] = 8'h33;
        lut[85] = 8'h34;
        lut[86] = 8'h36;
        lut[87] = 8'h37;
        lut[88] = 8'h38;
        lut[89] = 8'h3A;
        lut[90] = 8'h3B;
        lut[91] = 8'h3D;
        lut[92] = 8'h3E;
        lut[93] = 8'h3F;
        lut[94] = 8'h41;
        lut[95] = 8'h43;
        lut[96] = 8'h44;
        lut[97] = 8'h46;
        lut[98] = 8'h47;
        lut[99] = 8'h49;
        lut[100] = 8'h4B;
        lut[101] = 8'h4C;
        lut[102] = 8'h4E;
        lut[103] = 8'h50;
        lut[104] = 8'h51;
        lut[105] = 8'h53;
        lut[106] = 8'h55;
        lut[107] = 8'h57;
        lut[108] = 8'h58;
        lut[109] = 8'h5A;
        lut[110] = 8'h5C;
        lut[111] = 8'h5E;
        lut[112] = 8'h60;
        lut[113] = 8'h62;
        lut[114] = 8'h64;
        lut[115] = 8'h65;
        lut[116] = 8'h67;
        lut[117] = 8'h69;
        lut[118] = 8'h6B;
        lut[119] = 8'h6D;
        lut[120] = 8'h6F;
        lut[121] = 8'h71;
        lut[122] = 8'h73;
        lut[123] = 8'h75;
        lut[124] = 8'h77;
        lut[125] = 8'h79;
        lut[126] = 8'h7B;
        lut[127] = 8'h7D;
        lut[128] = 8'h7F;
        lut[129] = 8'h81;
        lut[130] = 8'h83;
        lut[131] = 8'h85;
        lut[132] = 8'h87;
        lut[133] = 8'h89;
        lut[134] = 8'h8B;
        lut[135] = 8'h8D;
        lut[136] = 8'h8F;
        lut[137] = 8'h91;
        lut[138] = 8'h93;
        lut[139] = 8'h95;
        lut[140] = 8'h97;
        lut[141] = 8'h99;
        lut[142] = 8'h9A;
        lut[143] = 8'h9C;
        lut[144] = 8'h9E;
        lut[145] = 8'hA0;
        lut[146] = 8'hA2;
        lut[147] = 8'hA4;
        lut[148] = 8'hA6;
        lut[149] = 8'hA7;
        lut[150] = 8'hA9;
        lut[151] = 8'hAB;
        lut[152] = 8'hAD;
        lut[153] = 8'hAE;
        lut[154] = 8'hB0;
        lut[155] = 8'hB2;
        lut[156] = 8'hB3;
        lut[157] = 8'hB5;
        lut[158] = 8'hB7;
        lut[159] = 8'hB8;
        lut[160] = 8'hBA;
        lut[161] = 8'hBB;
        lut[162] = 8'hBD;
        lut[163] = 8'hBF;
        lut[164] = 8'hC0;
        lut[165] = 8'hC1;
        lut[166] = 8'hC3;
        lut[167] = 8'hC4;
        lut[168] = 8'hC6;
        lut[169] = 8'hC7;
        lut[170] = 8'hC8;
        lut[171] = 8'hCA;
        lut[172] = 8'hCB;
        lut[173] = 8'hCC;
        lut[174] = 8'hCE;
        lut[175] = 8'hCF;
        lut[176] = 8'hD0;
        lut[177] = 8'hD1;
        lut[178] = 8'hD2;
        lut[179] = 8'hD3;
        lut[180] = 8'hD5;
        lut[181] = 8'hD6;
        lut[182] = 8'hD7;
        lut[183] = 8'hD8;
        lut[184] = 8'hD9;
        lut[185] = 8'hDA;
        lut[186] = 8'hDB;
        lut[187] = 8'hDC;
        lut[188] = 8'hDD;
        lut[189] = 8'hDE;
        lut[190] = 8'hDE;
        lut[191] = 8'hDF;
        lut[192] = 8'hE0;
        lut[193] = 8'hE1;
        lut[194] = 8'hE2;
        lut[195] = 8'hE3;
        lut[196] = 8'hE3;
        lut[197] = 8'hE4;
        lut[198] = 8'hE5;
        lut[199] = 8'hE5;
        lut[200] = 8'hE6;
        lut[201] = 8'hE7;
        lut[202] = 8'hE8;
        lut[203] = 8'hE8;
        lut[204] = 8'hE9;
        lut[205] = 8'hE9;
        lut[206] = 8'hEA;
        lut[207] = 8'hEB;
        lut[208] = 8'hEB;
        lut[209] = 8'hEC;
        lut[210] = 8'hEC;
        lut[211] = 8'hED;
        lut[212] = 8'hED;
        lut[213] = 8'hEE;
        lut[214] = 8'hEE;
        lut[215] = 8'hEF;
        lut[216] = 8'hEF;
        lut[217] = 8'hF0;
        lut[218] = 8'hF0;
        lut[219] = 8'hF0;
        lut[220] = 8'hF1;
        lut[221] = 8'hF1;
        lut[222] = 8'hF2;
        lut[223] = 8'hF2;
        lut[224] = 8'hF2;
        lut[225] = 8'hF3;
        lut[226] = 8'hF3;
        lut[227] = 8'hF3;
        lut[228] = 8'hF4;
        lut[229] = 8'hF4;
        lut[230] = 8'hF4;
        lut[231] = 8'hF5;
        lut[232] = 8'hF5;
        lut[233] = 8'hF5;
        lut[234] = 8'hF6;
        lut[235] = 8'hF6;
        lut[236] = 8'hF6;
        lut[237] = 8'hF6;
        lut[238] = 8'hF7;
        lut[239] = 8'hF7;
        lut[240] = 8'hF7;
        lut[241] = 8'hF7;
        lut[242] = 8'hF7;
        lut[243] = 8'hF8;
        lut[244] = 8'hF8;
        lut[245] = 8'hF8;
        lut[246] = 8'hF8;
        lut[247] = 8'hF8;
        lut[248] = 8'hF9;
        lut[249] = 8'hF9;
        lut[250] = 8'hF9;
        lut[251] = 8'hF9;
        lut[252] = 8'hF9;
        lut[253] = 8'hF9;
        lut[254] = 8'hFA;
        lut[255] = 8'hFA;
    end

    // 在查找表中找到相应的Sigmoid近似值
    always @(*) begin
        sigmoid_value = lut[index];
        if (lut[index] > 8'h7F) begin
            decision = 1'b0;
        end 
        else begin
            decision = 1'b1;
        end
    end

endmodule
