import numpy as np

# 参数设置
num_entries = 2 ** 24  # LUT表的大小: 2^24
lut = []

# Sigmoid函数定义
def sigmoid(x):
    return 1 / (1 + np.exp(-x))

# 生成查找表数据
for i in range(num_entries):
    # 将输入映射到合适的区间
    x = (i - num_entries // 2) / (num_entries // 8)
    # 计算Sigmoid值并量化到8位
    value = int(sigmoid(x) * 255)
    lut.append(value)

# 打印生成的查找表数据
for i, val in enumerate(lut):
    print(f"lut[{i}] = 8'h{val:02X};")
