//-------------------------------------------------------------------------------
//** Part         : Convolutional Neural Network Accelerator
//** File name    : top_tb.v
//** Description  : Testbench for CNN NoC dataset - single input
//** Author       : Haosen Yu
//** Email        : haosenyu@hotmail.com
//** Revision     : Version 1.0
//** Date         : 2023-04-12 14:30:26
//** LastEditTime : 2024-05-15 03:26:27
//** 
//** Copyright (c) 2023 by Haosen Yu, All Rights Reserved. 
//-------------------------------------------------------------------------------

module top_tb();

reg clk, rst_n;
reg [23:0] pixels [0:239];
reg [7:0] img_idx; // max 2^8=256 input images
reg [23:0] data_in;
reg [23:0] fc_out_data;
reg valid_out_4;

cnn_top cnn(
  .clk(clk),
  .rst_n(rst_n),
  .data_in(data_in),
  .fc_out_data(fc_out_data),
  .decision(decision),
  .valid_out_4(valid_out_4)
);

// Clock generation
always #5 clk = ~clk;

// Read image text file
initial begin
  $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/inputData/1_0_Batch1.txt", pixels);
  clk <= 1'b0;
  rst_n <= 1'b1;
  #3
  rst_n <= 1'b0;
  #3
  rst_n <= 1'b1;
end

always @(posedge clk) begin
  if(~rst_n) begin
    img_idx <= 0;
  end else begin
    if(img_idx < 8'd240) begin
      img_idx <= img_idx + 1'b1;
    end
    data_in <= pixels[img_idx];
  end
end

endmodule