//-------------------------------------------------------------------------------
//** Part         : Convolutional Neural Network Accelerator
//** File name    : cnn_top.v
//** Description  : CNN Classification Module
//** Author       : Haosen Yu
//** Email        : haosenyu@hotmail.com
//** Revision     : Version 1.0
//** Date         : 2023-04-12 15:43:05
//** LastEditTime : 2024-05-15 03:17:42
//** 
//** Copyright (c) 2023 by Haosen Yu, All Rights Reserved. 
//-------------------------------------------------------------------------------

module cnn_top( 
  input                     clk,
  input                     rst_n,
  input [23:0]              data_in,
  output wire signed [23:0] fc_out_data,
  output wire               decision,
  output wire               valid_out_4 
  
  //debug signals

  //Comparison Module Debug
  //output wire [11:0] buffer0  ,
  //output wire [11:0] buffer1  ,
  //output wire [11:0] buffer2  ,
  //output wire [11:0] buffer3  ,
  //output wire [11:0] buffer4  ,
  //output wire [11:0] buffer5  ,
  //output wire [11:0] buffer6  ,
  //output wire [11:0] buffer7  ,
  //output wire [11:0] buffer8  ,
  //output wire [11:0] buffer9  ,
  //output wire [11:0] max1     ,
  //output wire [7:0]  weight1  ,
  //output wire [11:0] fc_out_data ,
  //output wire        valid_out_5 ,

  //Fully Connected Module Debug 
  //output wire         valid_out_4   ,
  //output wire signed [11:0]  max2_value1  ,
  //output wire signed [11:0]  max2_value2  ,
  //output wire signed [11:0]  max2_value3  ,
  //output wire [7:0]   weight_fc
  );

wire signed [24:0] conv_out_1, conv_out_2, conv_out_3, conv_out_4, conv_out_5, conv_out_6, conv_out_7, conv_out_8;
wire signed [23:0] max_value_1, max_value_2, max_value_3, max_value_4, max_value_5, max_value_6, max_value_7, max_value_8;
wire signed [7:0] sigmoid_out;
wire valid_out_1, valid_out_2, valid_out_3;// valid_out_4;

//wire signed [23:0] fc_out_data;
//wire decision;
//wire [23:0] data_in;

// Module Instantiation
conv1_layer conv1_layer(
  .clk(clk),
  .rst_n(rst_n),
  .data_in(data_in),
  .conv_out_1(conv_out_1),
  .conv_out_2(conv_out_2),
  .conv_out_3(conv_out_3),
  .conv_out_4(conv_out_4),
  .conv_out_5(conv_out_5),
  .conv_out_6(conv_out_6),
  .conv_out_7(conv_out_7),
  .conv_out_8(conv_out_8),
  .valid_out_conv(valid_out_1)
);

maxpool_relu #(.CONV_BIT(37), .OUT_WIDTH(7), .OUT_HEIGHT(4), .OUT_WIDTH_BIT(3))
maxpool_relu_1(
  .clk(clk),
  .rst_n(rst_n),
  .valid_in(valid_out_1),
  .conv_out_1(conv_out_1),
  .conv_out_2(conv_out_2),
  .conv_out_3(conv_out_3),
  .conv_out_4(conv_out_4),
  .conv_out_5(conv_out_5),
  .conv_out_6(conv_out_6),
  .conv_out_7(conv_out_7),
  .conv_out_8(conv_out_8),
  .max_value_1(max_value_1),
  .max_value_2(max_value_2),
  .max_value_3(max_value_3),
  .max_value_4(max_value_4),
  .max_value_5(max_value_5),
  .max_value_6(max_value_6),
  .max_value_7(max_value_7),
  .max_value_8(max_value_8),
  .valid_out_relu(valid_out_2)
);

fully_connected #(.INPUT_NUM(224), .OUTPUT_NUM(2), .DATA_BITS(16))
flatten_dense(
  .clk(clk),
  .rst_n(rst_n),
  .valid_in(valid_out_2),
  .data_in_1(max_value_1),
  .data_in_2(max_value_2),
  .data_in_3(max_value_3),
  .data_in_4(max_value_4),
  .data_in_5(max_value_5),
  .data_in_6(max_value_6),
  .data_in_7(max_value_7),
  .data_in_8(max_value_8),
  .data_out(fc_out_data),
  .valid_out_fc(valid_out_3)
);

//Classifications Layer
sigmoid_lut sigmoid_layer(
  //.clk(clk),
  //.rst_n(rst_n),
  //.valid_in(valid_out_3),
  //.valid_out(valid_out_4),
  .index(fc_out_data),
  .sigmoid_value(sigmoid_out),
  .decision(decision)
);



//classifications Layer
// comparator comparator(
//   .clk(clk),
//   .rst_n(rst_n),
//   .valid_in(valid_out_3), //Data input valid
//   .data_in(fc_out_data),  //12bit input 
//   .decision(decision),    //Maximum value recognition results
//   .valid_out(valid_out_4)
// );

/*
//Comparator Module Debug
  comparator comparator
    (
      .clk       (clk         ),
      .rst_n     (rst_n       ),
      .valid_in  (valid_out_5 ),  //Data input valid
      .data_in   (fc_out_data ),  //12bit input 
      .decision  (decision    ),  //Maximum value recognition results
      .valid_out (valid_out_6 ),

      //debug signal 
      // .buffer0   (buffer0     ),  //12bit temp
      // .buffer1   (buffer1     ),  //12bit temp
      // .buffer2   (buffer2     ),  //12bit temp
      // .buffer3   (buffer3     ),  //12bit temp
      // .buffer4   (buffer4     ),  //12bit temp
      // .buffer5   (buffer5     ),  //12bit temp
      // .buffer6   (buffer6     ),  //12bit temp
      // .buffer7   (buffer7     ),  //12bit temp
      // .buffer8   (buffer8     ),  //12bit temp
      // .buffer9   (buffer9     ),  //12bit temp
      // .max1      (max1        )   //12bit temp
    );
*/

//----------- Begin Cut here for INSTANTIATION Template ---// INST_TAG
//CNN Logic Analysis Module
//
//ila CNN_ila (
//  .clk      (clk                ), // input wire clk
//
////conv1_layer debug signals
//  .probe0   (data_in            ), // input wire [7:0]  probe0      //ROM input data (Picture data: 28*28 = 784 x 8bit)
//  .probe1   (rst_n              ), // input wire [0:0]  probe1      //cnn_rstn  CNN reset signal
//  .probe2   (conv_out_1         ), // input wire [11:0]  probe2 
//  .probe3   (conv_out_2         ), // input wire [11:0]  probe3 
//  .probe4   (conv_out_3         ), // input wire [11:0]  probe4 
//  .probe5   (valid_out_1        ), // input wire [0:0]  probe5 
//
////max_pool_relu1 debug signals
//  .probe6   (max_value_1        ), // input wire [11:0]  probe6 
//  .probe7   (max_value_2        ), // input wire [11:0]  probe7 
//  .probe8   (max_value_3        ), // input wire [11:0]  probe8 
//  .probe9   (valid_out_2        ), // input wire [0:0]  probe9 
//
////conv2_layer debug signals
//  .probe10  (conv2_out_1        ), // input wire [11:0]  probe10 
//  .probe11  (conv2_out_2        ), // input wire [11:0]  probe11 
//  .probe12  (conv2_out_3        ), // input wire [11:0]  probe12 
//  .probe13  (valid_out_3        ), // input wire [0:0]  probe13 
//
////maxpool_relu2  debug signals 
//  .probe14  (max2_value_1       ), // input wire [11:0]  probe14 
//  .probe15  (max2_value_2       ), // input wire [11:0]  probe15 
//  .probe16  (max2_value_3       ), // input wire [11:0]  probe16 
//  .probe17  (valid_out_4        ), // input wire [0:0]  probe17 
//
////FC layer debug signals 
//  .probe18  (fc_out_data        ), // input wire [11:0]  probe18 
//  .probe19  (valid_out_5        ), // input wire [0:0]  probe19 
//
////compare debug signals
//  .probe20  (valid_out_6        ), // input wire [0:0]  probe20 
//  .probe21  (decision           ) // input wire [3:0]  probe21
//);
//
//// INST_TAG_END ------ End INSTANTIATION Template ---------

endmodule