//-------------------------------------------------------------------------------
//** Part         : Convolutional Neural Network Accelerator
//** File name    : conv1_layer.v
//** Description  : 1st Convolution Layer for CNN MNIST dataset
//** Author       : Haosen Yu
//** Email        : haosenyu@hotmail.com
//** Revision     : Version 1.0
//** Date         : 2023-04-12 15:25:19
//** LastEditTime : 2024-05-15 01:38:55
//** 
//** Copyright (c) 2023 by Haosen Yu, All Rights Reserved. 
//-------------------------------------------------------------------------------
 
 module conv1_layer (
   input clk,
   input rst_n,
   input [23:0] data_in,
   output [24:0] conv_out_1, conv_out_2, conv_out_3, conv_out_4, conv_out_5, conv_out_6, conv_out_7, conv_out_8,
   output valid_out_conv , //Active signal of convolution
   output wire [23:0] weight1
 );

 wire [23:0] data_out_0, data_out_1, data_out_2, 
 data_out_3, data_out_4, data_out_5, 
 data_out_6, data_out_7, data_out_8;
 wire valid_out_buf;  //Active signal of buffer

 conv1_buf #(.WIDTH(16), .HEIGHT(15), .DATA_BITS(24)) conv1_buf(
   .clk(clk),
   .rst_n(rst_n),
   .data_in(data_in),
   .data_out_0(data_out_0),
   .data_out_1(data_out_1),
   .data_out_2(data_out_2),
   .data_out_3(data_out_3),
   .data_out_4(data_out_4),
   .data_out_5(data_out_5),
   .data_out_6(data_out_6),
   .data_out_7(data_out_7),
   .data_out_8(data_out_8),
   .valid_out_buf(valid_out_buf)
 );

 conv1_calc #(.WIDTH(16), .HEIGHT(15), .DATA_BITS(24)) conv1_calc(
   .valid_out_buf(valid_out_buf),
   .data_out_0(data_out_0),
   .data_out_1(data_out_1),
   .data_out_2(data_out_2),
   .data_out_3(data_out_3),
   .data_out_4(data_out_4),
   .data_out_5(data_out_5),
   .data_out_6(data_out_6),
   .data_out_7(data_out_7),
   .data_out_8(data_out_8),
   .conv_out_1(conv_out_1),
   .conv_out_2(conv_out_2),
   .conv_out_3(conv_out_3),
   .conv_out_4(conv_out_4),
   .conv_out_5(conv_out_5),
   .conv_out_6(conv_out_6),
   .conv_out_7(conv_out_7),
   .conv_out_8(conv_out_8),
   .valid_out_calc(valid_out_conv),
   .weight1 (weight1 ),
   .rst_n   (rst_n )
 );
 endmodule