//-------------------------------------------------------------------------------
//** Part         : Convolutional Neural Network Accelerator
//** File name    : fully_connected.v
//** Description  : Fully Connected Layer for CNN
//** Author       : Haosen Yu
//** Email        : haosenyu@hotmail.com
//** Revision     : Version 1.0
//** Date         : 2023-04-12 15:31:42
//** LastEditTime : 2024-05-15 02:33:19
//** 
//** Copyright (c) 2023 by Haosen Yu, All Rights Reserved. 
//-------------------------------------------------------------------------------

 module fully_connected #(parameter INPUT_NUM = 224, OUTPUT_NUM = 2, DATA_BITS = 24) ( //224 = 4*7*8
   input clk,
   input rst_n,
   input valid_in,
   input signed [24:0] data_in_1, data_in_2, data_in_3, data_in_4, data_in_5, data_in_6, data_in_7, data_in_8,
   output wire [DATA_BITS - 1:0] data_out,
   output reg valid_out_fc,
   output wire [DATA_BITS - 1:0] weight_fc   
 );

 //wire   [23:0] weight_fc;
 localparam INPUT_WIDTH = 28; // 4(H)*7(W)
 localparam INPUT_NUM_DATA_BITS = 5;

 reg state;
 reg [INPUT_NUM_DATA_BITS - 1:0] buf_idx;
 reg [3:0] out_idx; //max 16 types of output classes
 reg signed [DATA_BITS - 1:0] buffer [0:INPUT_NUM - 1];
 reg signed [DATA_BITS - 1:0] weight [0:INPUT_NUM * OUTPUT_NUM - 1];
 reg signed [DATA_BITS - 1:0] bias [0:OUTPUT_NUM - 1];
   
 wire signed [55:0] calc_out;
 wire signed [DATA_BITS - 1:0] data1, data2, data3, data4, data5, data6, data7, data8;
 wire signed [47:0] exp_bias [0:OUTPUT_NUM - 1];

assign weight_fc = weight[0];

//Non-synthesizable rom assignments
/*
 initial begin
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/fc_weight.txt", weight);
   $readmemh("D:/OneDrive/Repository/CNN_MNIST/CNN_NoC/weightData/fc_bias.txt", bias);
 end
*/
//weights

always @(*) begin 
  if(~rst_n) begin
    weight[0]  =   24'h0000fe ;
    weight[1]  =   24'h000018 ;
    weight[2]  =   24'h0000fe ;
    weight[3]  =   24'h0000f8 ;
    weight[4]  =   24'h000013 ;
    weight[5]  =   24'h000013 ;
    weight[6]  =   24'h0000fc ;
    weight[7]  =   24'h000014 ;
    weight[8]  =   24'h000011 ;
    weight[9]  =   24'h0000fb ;
    weight[10]  =   24'h0000f8 ;
    weight[11]  =   24'h000022 ;
    weight[12]  =   24'h0000fd ;
    weight[13]  =   24'h0000ee ;
    weight[14]  =   24'h000000 ;
    weight[15]  =   24'h000001 ;
    weight[16]  =   24'h0000fd ;
    weight[17]  =   24'h000002 ;
    weight[18]  =   24'h00000f ;
    weight[19]  =   24'h000006 ;
    weight[20]  =   24'h0000f2 ;
    weight[21]  =   24'h0000f5 ;
    weight[22]  =   24'h0000e7 ;
    weight[23]  =   24'h0000fd ;
    weight[24]  =   24'h0000df ;
    weight[25]  =   24'h0000e3 ;
    weight[26]  =   24'h0000f2 ;
    weight[27]  =   24'h000004 ;
    weight[28]  =   24'h0000f1 ;
    weight[29]  =   24'h000012 ;
    weight[30]  =   24'h00001a ;
    weight[31]  =   24'h0000fa ;
    weight[32]  =   24'h0000f5 ;
    weight[33]  =   24'h000009 ;
    weight[34]  =   24'h000003 ;
    weight[35]  =   24'h000002 ;
    weight[36]  =   24'h0000fd ;
    weight[37]  =   24'h0000fa ;
    weight[38]  =   24'h00000d ;
    weight[39]  =   24'h000023 ;
    weight[40]  =   24'h000014 ;
    weight[41]  =   24'h0000ef ;
    weight[42]  =   24'h0000e0 ;
    weight[43]  =   24'h0000fc ;
    weight[44]  =   24'h000027 ;
    weight[45]  =   24'h0000eb ;
    weight[46]  =   24'h0000cc ;
    weight[47]  =   24'h00000a ;
    weight[48]  =   24'h0000fe ;
    weight[49]  =   24'h0000ef ;
    weight[50]  =   24'h000030 ;
    weight[51]  =   24'h00000d ;
    weight[52]  =   24'h000009 ;
    weight[53]  =   24'h000009 ;
    weight[54]  =   24'h00000a ;
    weight[55]  =   24'h0000f3 ;
    weight[56]  =   24'h000018 ;
    weight[57]  =   24'h00000f ;
    weight[58]  =   24'h0000ef ;
    weight[59]  =   24'h0000ec ;
    weight[60]  =   24'h000014 ;
    weight[61]  =   24'h000028 ;
    weight[62]  =   24'h0000e0 ;
    weight[63]  =   24'h0000f9 ;
    weight[64]  =   24'h000001 ;
    weight[65]  =   24'h000017 ;
    weight[66]  =   24'h0000dd ;
    weight[67]  =   24'h0000f1 ;
    weight[68]  =   24'h00000b ;
    weight[69]  =   24'h0000f4 ;
    weight[70]  =   24'h0000ed ;
    weight[71]  =   24'h0000e8 ;
    weight[72]  =   24'h000002 ;
    weight[73]  =   24'h0000f4 ;
    weight[74]  =   24'h0000ef ;
    weight[75]  =   24'h0000f2 ;
    weight[76]  =   24'h000011 ;
    weight[77]  =   24'h0000f4 ;
    weight[78]  =   24'h0000f7 ;
    weight[79]  =   24'h000020 ;
    weight[80]  =   24'h0000d9 ;
    weight[81]  =   24'h000031 ;
    weight[82]  =   24'h0000d4 ;
    weight[83]  =   24'h0000d6 ;
    weight[84]  =   24'h0000dd ;
    weight[85]  =   24'h000040 ;
    weight[86]  =   24'h0000fe ;
    weight[87]  =   24'h0000fe ;
    weight[88]  =   24'h0000ed ;
    weight[89]  =   24'h000010 ;
    weight[90]  =   24'h0000f5 ;
    weight[91]  =   24'h000005 ;
    weight[92]  =   24'h0000c5 ;
    weight[93]  =   24'h000021 ;
    weight[94]  =   24'h000003 ;
    weight[95]  =   24'h0000fa ;
    weight[96]  =   24'h0000e3 ;
    weight[97]  =   24'h0000f5 ;
    weight[98]  =   24'h0000ed ;
    weight[99]  =   24'h0000e4 ;
    weight[100]  =   24'h00000f ;
    weight[101]  =   24'h000011 ;
    weight[102]  =   24'h000016 ;
    weight[103]  =   24'h00001b ;
    weight[104]  =   24'h000038 ;
    weight[105]  =   24'h000029 ;
    weight[106]  =   24'h000009 ;
    weight[107]  =   24'h000000 ;
    weight[108]  =   24'h0000fd ;
    weight[109]  =   24'h0000ed ;
    weight[110]  =   24'h0000de ;
    weight[111]  =   24'h0000e3 ;
    weight[112]  =   24'h00001e ;
    weight[113]  =   24'h000006 ;
    weight[114]  =   24'h00000e ;
    weight[115]  =   24'h0000f1 ;
    weight[116]  =   24'h00003a ;
    weight[117]  =   24'h000014 ;
    weight[118]  =   24'h0000fd ;
    weight[119]  =   24'h0000f1 ;
    weight[120]  =   24'h000012 ;
    weight[121]  =   24'h0000fa ;
    weight[122]  =   24'h000002 ;
    weight[123]  =   24'h000014 ;
    weight[124]  =   24'h0000e7 ;
    weight[125]  =   24'h0000fa ;
    weight[126]  =   24'h000004 ;
    weight[127]  =   24'h00002a ;
    weight[128]  =   24'h00001c ;
    weight[129]  =   24'h000028 ;
    weight[130]  =   24'h00003d ;
    weight[131]  =   24'h000006 ;
    weight[132]  =   24'h0000fe ;
    weight[133]  =   24'h0000ee ;
    weight[134]  =   24'h0000f6 ;
    weight[135]  =   24'h0000f4 ;
    weight[136]  =   24'h0000d0 ;
    weight[137]  =   24'h0000f1 ;
    weight[138]  =   24'h0000dd ;
    weight[139]  =   24'h000002 ;
    weight[140]  =   24'h000000 ;
    weight[141]  =   24'h0000fa ;
    weight[142]  =   24'h00000c ;
    weight[143]  =   24'h000010 ;
    weight[144]  =   24'h0000cc ;
    weight[145]  =   24'h0000f9 ;
    weight[146]  =   24'h00000f ;
    weight[147]  =   24'h00001e ;
    weight[148]  =   24'h0000f2 ;
    weight[149]  =   24'h000011 ;
    weight[150]  =   24'h000001 ;
    weight[151]  =   24'h000012 ;
    weight[152]  =   24'h0000e1 ;
    weight[153]  =   24'h0000db ;
    weight[154]  =   24'h0000d0 ;
    weight[155]  =   24'h000003 ;
    weight[156]  =   24'h000001 ;
    weight[157]  =   24'h00001c ;
    weight[158]  =   24'h000018 ;
    weight[159]  =   24'h000017 ;
    weight[160]  =   24'h00001e ;
    weight[161]  =   24'h000014 ;
    weight[162]  =   24'h000008 ;
    weight[163]  =   24'h000004 ;
    weight[164]  =   24'h000017 ;
    weight[165]  =   24'h000003 ;
    weight[166]  =   24'h00000b ;
    weight[167]  =   24'h00000b ;
    weight[168]  =   24'h000000 ;
    weight[169]  =   24'h000001 ;
    weight[170]  =   24'h000011 ;
    weight[171]  =   24'h0000fc ;
    weight[172]  =   24'h000025 ;
    weight[173]  =   24'h0000fa ;
    weight[174]  =   24'h000014 ;
    weight[175]  =   24'h0000f0 ;
    weight[176]  =   24'h0000fa ;
    weight[177]  =   24'h000026 ;
    weight[178]  =   24'h000017 ;
    weight[179]  =   24'h0000fe ;
    weight[180]  =   24'h0000e8 ;
    weight[181]  =   24'h000000 ;
    weight[182]  =   24'h0000fb ;
    weight[183]  =   24'h0000f7 ;
    weight[184]  =   24'h0000e6 ;
    weight[185]  =   24'h000013 ;
    weight[186]  =   24'h000012 ;
    weight[187]  =   24'h0000fc ;
    weight[188]  =   24'h0000ed ;
    weight[189]  =   24'h0000f8 ;
    weight[190]  =   24'h000000 ;
    weight[191]  =   24'h000008 ;
    weight[192]  =   24'h000014 ;
    weight[193]  =   24'h000020 ;
    weight[194]  =   24'h000020 ;
    weight[195]  =   24'h00002c ;
    weight[196]  =   24'h000027 ;
    weight[197]  =   24'h0000e9 ;
    weight[198]  =   24'h0000f3 ;
    weight[199]  =   24'h00001a ;
    weight[200]  =   24'h0000ef ;
    weight[201]  =   24'h0000db ;
    weight[202]  =   24'h000006 ;
    weight[203]  =   24'h0000ec ;
    weight[204]  =   24'h00001b ;
    weight[205]  =   24'h000016 ;
    weight[206]  =   24'h0000f5 ;
    weight[207]  =   24'h0000f5 ;
    weight[208]  =   24'h0000f9 ;
    weight[209]  =   24'h0000d0 ;
    weight[210]  =   24'h0000cc ;
    weight[211]  =   24'h0000d7 ;
    weight[212]  =   24'h0000fb ;
    weight[213]  =   24'h000017 ;
    weight[214]  =   24'h000000 ;
    weight[215]  =   24'h0000ef ;
    weight[216]  =   24'h000019 ;
    weight[217]  =   24'h000018 ;
    weight[218]  =   24'h00001e ;
    weight[219]  =   24'h00001c ;
    weight[220]  =   24'h0000f8 ;
    weight[221]  =   24'h0000f6 ;
    weight[222]  =   24'h0000e6 ;
    weight[223]  =   24'h0000f7 ;
  end 
  else begin
      weight[0]  =      weight[0]  ;
      weight[1]  =      weight[1]  ;
      weight[2]  =      weight[2]  ;
      weight[3]  =      weight[3]  ;
      weight[4]  =      weight[4]  ;
      weight[5]  =      weight[5]  ;
      weight[6]  =      weight[6]  ;
      weight[7]  =      weight[7]  ;
      weight[8]  =      weight[8]  ;
      weight[9]  =      weight[9]  ;
      weight[10]  =     weight[10] ;
      weight[11]  =     weight[11] ;
      weight[12]  =     weight[12] ;
      weight[13]  =     weight[13] ;
      weight[14]  =     weight[14] ;
      weight[15]  =     weight[15] ;
      weight[16]  =     weight[16] ;
      weight[17]  =     weight[17] ;
      weight[18]  =     weight[18] ;
      weight[19]  =     weight[19] ;
      weight[20]  =     weight[20] ;
      weight[21]  =     weight[21] ;
      weight[22]  =     weight[22] ;
      weight[23]  =     weight[23] ;
      weight[24]  =     weight[24] ;
      weight[25]  =     weight[25] ;
      weight[26]  =     weight[26] ;
      weight[27]  =     weight[27] ;
      weight[28]  =     weight[28] ;
      weight[29]  =     weight[29] ;
      weight[30]  =     weight[30] ;
      weight[31]  =     weight[31] ;
      weight[32]  =     weight[32] ;
      weight[33]  =     weight[33] ;
      weight[34]  =     weight[34] ;
      weight[35]  =     weight[35] ;
      weight[36]  =     weight[36] ;
      weight[37]  =     weight[37] ;
      weight[38]  =     weight[38] ;
      weight[39]  =     weight[39] ;
      weight[40]  =     weight[40] ;
      weight[41]  =     weight[41] ;
      weight[42]  =     weight[42] ;
      weight[43]  =     weight[43] ;
      weight[44]  =     weight[44] ;
      weight[45]  =     weight[45] ;
      weight[46]  =     weight[46] ;
      weight[47]  =     weight[47] ;
      weight[48]  =     weight[48] ;
      weight[49]  =     weight[49] ;
      weight[50]  =     weight[50] ;
      weight[51]  =     weight[51] ;
      weight[52]  =     weight[52] ;
      weight[53]  =     weight[53] ;
      weight[54]  =     weight[54] ;
      weight[55]  =     weight[55] ;
      weight[56]  =     weight[56] ;
      weight[57]  =     weight[57] ;
      weight[58]  =     weight[58] ;
      weight[59]  =     weight[59] ;
      weight[60]  =     weight[60] ;
      weight[61]  =     weight[61] ;
      weight[62]  =     weight[62] ;
      weight[63]  =     weight[63] ;
      weight[64]  =     weight[64] ;
      weight[65]  =     weight[65] ;
      weight[66]  =     weight[66] ;
      weight[67]  =     weight[67] ;
      weight[68]  =     weight[68] ;
      weight[69]  =     weight[69] ;
      weight[70]  =     weight[70] ;
      weight[71]  =     weight[71] ;
      weight[72]  =     weight[72] ;
      weight[73]  =     weight[73] ;
      weight[74]  =     weight[74] ;
      weight[75]  =     weight[75] ;
      weight[76]  =     weight[76] ;
      weight[77]  =     weight[77] ;
      weight[78]  =     weight[78] ;
      weight[79]  =     weight[79] ;
      weight[80]  =     weight[80] ;
      weight[81]  =     weight[81] ;
      weight[82]  =     weight[82] ;
      weight[83]  =     weight[83] ;
      weight[84]  =     weight[84] ;
      weight[85]  =     weight[85] ;
      weight[86]  =     weight[86] ;
      weight[87]  =     weight[87] ;
      weight[88]  =     weight[88] ;
      weight[89]  =     weight[89] ;
      weight[90]  =     weight[90] ;
      weight[91]  =     weight[91] ;
      weight[92]  =     weight[92] ;
      weight[93]  =     weight[93] ;
      weight[94]  =     weight[94] ;
      weight[95]  =     weight[95] ;
      weight[96]  =     weight[96] ;
      weight[97]  =     weight[97] ;
      weight[98]  =     weight[98] ;
      weight[99]  =     weight[99] ;
      weight[100]  =    weight[100];
      weight[101]  =    weight[101];
      weight[102]  =    weight[102];
      weight[103]  =    weight[103];
      weight[104]  =    weight[104];
      weight[105]  =    weight[105];
      weight[106]  =    weight[106];
      weight[107]  =    weight[107];
      weight[108]  =    weight[108];
      weight[109]  =    weight[109];
      weight[110]  =    weight[110];
      weight[111]  =    weight[111];
      weight[112]  =    weight[112];
      weight[113]  =    weight[113];
      weight[114]  =    weight[114];
      weight[115]  =    weight[115];
      weight[116]  =    weight[116];
      weight[117]  =    weight[117];
      weight[118]  =    weight[118];
      weight[119]  =    weight[119];
      weight[120]  =    weight[120];
      weight[121]  =    weight[121];
      weight[122]  =    weight[122];
      weight[123]  =    weight[123];
      weight[124]  =    weight[124];
      weight[125]  =    weight[125];
      weight[126]  =    weight[126];
      weight[127]  =    weight[127];
      weight[128]  =    weight[128];
      weight[129]  =    weight[129];
      weight[130]  =    weight[130];
      weight[131]  =    weight[131];
      weight[132]  =    weight[132];
      weight[133]  =    weight[133];
      weight[134]  =    weight[134];
      weight[135]  =    weight[135];
      weight[136]  =    weight[136];
      weight[137]  =    weight[137];
      weight[138]  =    weight[138];
      weight[139]  =    weight[139];
      weight[140]  =    weight[140];
      weight[141]  =    weight[141];
      weight[142]  =    weight[142];
      weight[143]  =    weight[143];
      weight[144]  =    weight[144];
      weight[145]  =    weight[145];
      weight[146]  =    weight[146];
      weight[147]  =    weight[147];
      weight[148]  =    weight[148];
      weight[149]  =    weight[149];
      weight[150]  =    weight[150];
      weight[151]  =    weight[151];
      weight[152]  =    weight[152];
      weight[153]  =    weight[153];
      weight[154]  =    weight[154];
      weight[155]  =    weight[155];
      weight[156]  =    weight[156];
      weight[157]  =    weight[157];
      weight[158]  =    weight[158];
      weight[159]  =    weight[159];
      weight[160]  =    weight[160];
      weight[161]  =    weight[161];
      weight[162]  =    weight[162];
      weight[163]  =    weight[163];
      weight[164]  =    weight[164];
      weight[165]  =    weight[165];
      weight[166]  =    weight[166];
      weight[167]  =    weight[167];
      weight[168]  =    weight[168];
      weight[169]  =    weight[169];
      weight[170]  =    weight[170];
      weight[171]  =    weight[171];
      weight[172]  =    weight[172];
      weight[173]  =    weight[173];
      weight[174]  =    weight[174];
      weight[175]  =    weight[175];
      weight[176]  =    weight[176];
      weight[177]  =    weight[177];
      weight[178]  =    weight[178];
      weight[179]  =    weight[179];
      weight[180]  =    weight[180];
      weight[181]  =    weight[181];
      weight[182]  =    weight[182];
      weight[183]  =    weight[183];
      weight[184]  =    weight[184];
      weight[185]  =    weight[185];
      weight[186]  =    weight[186];
      weight[187]  =    weight[187];
      weight[188]  =    weight[188];
      weight[189]  =    weight[189];
      weight[190]  =    weight[190];
      weight[191]  =    weight[191];
      weight[192]  =    weight[192];
      weight[193]  =    weight[193];
      weight[194]  =    weight[194];
      weight[195]  =    weight[195];
      weight[196]  =    weight[196];
      weight[197]  =    weight[197];
      weight[198]  =    weight[198];
      weight[199]  =    weight[199];
      weight[200]  =    weight[200];
      weight[201]  =    weight[201];
      weight[202]  =    weight[202];
      weight[203]  =    weight[203];
      weight[204]  =    weight[204];
      weight[205]  =    weight[205];
      weight[206]  =    weight[206];
      weight[207]  =    weight[207];
      weight[208]  =    weight[208];
      weight[209]  =    weight[209];
      weight[210]  =    weight[210];
      weight[211]  =    weight[211];
      weight[212]  =    weight[212];
      weight[213]  =    weight[213];
      weight[214]  =    weight[214];
      weight[215]  =    weight[215];
      weight[216]  =    weight[216];
      weight[217]  =    weight[217];
      weight[218]  =    weight[218];
      weight[219]  =    weight[219];
      weight[220]  =    weight[220];
      weight[221]  =    weight[221];
      weight[222]  =    weight[222];
      weight[223]  =    weight[223];
  end
end

//Bias
always @(*) begin 
  if(~rst_n) begin
     bias[0] = 24'h0000f5;
  end 
  else begin
      bias[0] = bias[0];
  end
end

assign exp_bias[0] = (bias[0][23] == 1) ? {8'b11111111, bias[0], 16'd0} : {8'd0, bias[0], 16'd0}; //Expanded to 48 bits

///End of ROM assignments


 assign data1 = {data_in_1[24],data_in_1[22:0]};
 assign data2 = {data_in_2[24],data_in_1[22:0]};
 assign data3 = {data_in_3[24],data_in_1[22:0]};
 assign data4 = {data_in_4[24],data_in_1[22:0]};
 assign data5 = {data_in_5[24],data_in_1[22:0]};
 assign data6 = {data_in_6[24],data_in_1[22:0]};
 assign data7 = {data_in_7[24],data_in_1[22:0]};
 assign data8 = {data_in_8[24],data_in_1[22:0]};
 
//  assign data1 = (data_in_1[36] == 1) ? {4'b1111, data_in_1} : {4'b0000, data_in_1};
//  assign data2 = (data_in_2[36] == 1) ? {4'b1111, data_in_2} : {4'b0000, data_in_2};
//  assign data3 = (data_in_3[36] == 1) ? {4'b1111, data_in_3} : {4'b0000, data_in_3};
//  assign data4 = (data_in_4[36] == 1) ? {4'b1111, data_in_4} : {4'b0000, data_in_4};
//  assign data5 = (data_in_5[36] == 1) ? {4'b1111, data_in_5} : {4'b0000, data_in_5};
//  assign data6 = (data_in_6[36] == 1) ? {4'b1111, data_in_6} : {4'b0000, data_in_6};
//  assign data7 = (data_in_7[36] == 1) ? {4'b1111, data_in_7} : {4'b0000, data_in_7};
//  assign data8 = (data_in_8[36] == 1) ? {4'b1111, data_in_8} : {4'b0000, data_in_8};
 
 always @(posedge clk) begin
   if(~rst_n) begin
     valid_out_fc <= 0;
     buf_idx <= 0;
     out_idx <= 0;
     state <= 0;
   end

   if(valid_out_fc == 1) begin
     valid_out_fc <= 0;
   end

   if(valid_in == 1) begin
     // Wait until 224 input data filled in buffer
     if(!state) begin
       buffer[buf_idx] <= data1;
       buffer[INPUT_WIDTH + buf_idx] <= data2;
       buffer[INPUT_WIDTH * 2 + buf_idx] <= data3;
       buffer[INPUT_WIDTH * 3 + buf_idx] <= data4;
       buffer[INPUT_WIDTH * 4 + buf_idx] <= data5;
       buffer[INPUT_WIDTH * 5 + buf_idx] <= data6;
       buffer[INPUT_WIDTH * 6 + buf_idx] <= data7;
       buffer[INPUT_WIDTH * 7 + buf_idx] <= data8;
       buf_idx <= buf_idx + 1'b1;
       if(buf_idx == INPUT_WIDTH - 1) begin
         buf_idx <= 0;
         state <= 1;
         valid_out_fc <= 1;
       end
     end 
     else begin // valid state
       out_idx <= out_idx + 1'b1;
       if(out_idx == OUTPUT_NUM - 1) begin
         out_idx <= 0;
       end
       valid_out_fc <= 1;
     end
   end
 end

 assign calc_out = weight[out_idx * INPUT_NUM] * buffer[0] + weight[out_idx * INPUT_NUM + 1] * buffer[1] + 
		  		weight[out_idx * INPUT_NUM + 2] * buffer[2] + weight[out_idx * INPUT_NUM + 3] * buffer[3] + 
  				weight[out_idx * INPUT_NUM + 4] * buffer[4] + weight[out_idx * INPUT_NUM + 5] * buffer[5] + 
	  			weight[out_idx * INPUT_NUM + 6] * buffer[6] + weight[out_idx * INPUT_NUM + 7] * buffer[7] + 
		  		weight[out_idx * INPUT_NUM + 8] * buffer[8] + weight[out_idx * INPUT_NUM + 9] * buffer[9] + 
  				weight[out_idx * INPUT_NUM + 10] * buffer[10] + weight[out_idx * INPUT_NUM + 11] * buffer[11] + 
  				weight[out_idx * INPUT_NUM + 12] * buffer[12] + weight[out_idx * INPUT_NUM + 13] * buffer[13] + 
	  			weight[out_idx * INPUT_NUM + 14] * buffer[14] + weight[out_idx * INPUT_NUM + 15] * buffer[15] + 
  				weight[out_idx * INPUT_NUM + 16] * buffer[16] + weight[out_idx * INPUT_NUM + 17] * buffer[17] + 
  				weight[out_idx * INPUT_NUM + 18] * buffer[18] + weight[out_idx * INPUT_NUM + 19] * buffer[19] + 
  				weight[out_idx * INPUT_NUM + 20] * buffer[20] + weight[out_idx * INPUT_NUM + 21] * buffer[21] + 
  				weight[out_idx * INPUT_NUM + 22] * buffer[22] + weight[out_idx * INPUT_NUM + 23] * buffer[23] + 
  				weight[out_idx * INPUT_NUM + 24] * buffer[24] + weight[out_idx * INPUT_NUM + 25] * buffer[25] + 
  				weight[out_idx * INPUT_NUM + 26] * buffer[26] + weight[out_idx * INPUT_NUM + 27] * buffer[27] + 
  				weight[out_idx * INPUT_NUM + 28] * buffer[28] + weight[out_idx * INPUT_NUM + 29] * buffer[29] + 
  				weight[out_idx * INPUT_NUM + 30] * buffer[30] + weight[out_idx * INPUT_NUM + 31] * buffer[31] + 
  				weight[out_idx * INPUT_NUM + 32] * buffer[32] + weight[out_idx * INPUT_NUM + 33] * buffer[33] + 
  				weight[out_idx * INPUT_NUM + 34] * buffer[34] + weight[out_idx * INPUT_NUM + 35] * buffer[35] + 
  				weight[out_idx * INPUT_NUM + 36] * buffer[36] + weight[out_idx * INPUT_NUM + 37] * buffer[37] + 
  				weight[out_idx * INPUT_NUM + 38] * buffer[38] + weight[out_idx * INPUT_NUM + 39] * buffer[39] + 
	  			weight[out_idx * INPUT_NUM + 40] * buffer[40] + weight[out_idx * INPUT_NUM + 41] * buffer[41] + 
	  			weight[out_idx * INPUT_NUM + 42] * buffer[42] + weight[out_idx * INPUT_NUM + 43] * buffer[43] + 
	  			weight[out_idx * INPUT_NUM + 44] * buffer[44] + weight[out_idx * INPUT_NUM + 45] * buffer[45] + 
  				weight[out_idx * INPUT_NUM + 46] * buffer[46] + weight[out_idx * INPUT_NUM + 47] * buffer[47] + 
          weight[out_idx * INPUT_NUM + 48] * buffer[48] + weight[out_idx * INPUT_NUM + 49] * buffer[49] + 
          weight[out_idx * INPUT_NUM + 50] * buffer[50] + weight[out_idx * INPUT_NUM + 51] * buffer[51] + 
          weight[out_idx * INPUT_NUM + 52] * buffer[52] + weight[out_idx * INPUT_NUM + 53] * buffer[53] + 
          weight[out_idx * INPUT_NUM + 54] * buffer[54] + weight[out_idx * INPUT_NUM + 55] * buffer[55] + 
          weight[out_idx * INPUT_NUM + 56] * buffer[56] + weight[out_idx * INPUT_NUM + 57] * buffer[57] + 
          weight[out_idx * INPUT_NUM + 58] * buffer[58] + weight[out_idx * INPUT_NUM + 59] * buffer[59] + 
          weight[out_idx * INPUT_NUM + 60] * buffer[60] + weight[out_idx * INPUT_NUM + 61] * buffer[61] + 
          weight[out_idx * INPUT_NUM + 62] * buffer[62] + weight[out_idx * INPUT_NUM + 63] * buffer[63] + 
          weight[out_idx * INPUT_NUM + 64] * buffer[64] + weight[out_idx * INPUT_NUM + 65] * buffer[65] + 
          weight[out_idx * INPUT_NUM + 66] * buffer[66] + weight[out_idx * INPUT_NUM + 67] * buffer[67] + 
          weight[out_idx * INPUT_NUM + 68] * buffer[68] + weight[out_idx * INPUT_NUM + 69] * buffer[69] + 
          weight[out_idx * INPUT_NUM + 70] * buffer[70] + weight[out_idx * INPUT_NUM + 71] * buffer[71] + 
          weight[out_idx * INPUT_NUM + 72] * buffer[72] + weight[out_idx * INPUT_NUM + 73] * buffer[73] + 
          weight[out_idx * INPUT_NUM + 74] * buffer[74] + weight[out_idx * INPUT_NUM + 75] * buffer[75] + 
          weight[out_idx * INPUT_NUM + 76] * buffer[76] + weight[out_idx * INPUT_NUM + 77] * buffer[77] + 
          weight[out_idx * INPUT_NUM + 78] * buffer[78] + weight[out_idx * INPUT_NUM + 79] * buffer[79] + 
          weight[out_idx * INPUT_NUM + 80] * buffer[80] + weight[out_idx * INPUT_NUM + 81] * buffer[81] + 
          weight[out_idx * INPUT_NUM + 82] * buffer[82] + weight[out_idx * INPUT_NUM + 83] * buffer[83] + 
          weight[out_idx * INPUT_NUM + 84] * buffer[84] + weight[out_idx * INPUT_NUM + 85] * buffer[85] + 
          weight[out_idx * INPUT_NUM + 86] * buffer[86] + weight[out_idx * INPUT_NUM + 87] * buffer[87] + 
          weight[out_idx * INPUT_NUM + 88] * buffer[88] + weight[out_idx * INPUT_NUM + 89] * buffer[89] + 
          weight[out_idx * INPUT_NUM + 90] * buffer[90] + weight[out_idx * INPUT_NUM + 91] * buffer[91] + 
          weight[out_idx * INPUT_NUM + 92] * buffer[92] + weight[out_idx * INPUT_NUM + 93] * buffer[93] + 
          weight[out_idx * INPUT_NUM + 94] * buffer[94] + weight[out_idx * INPUT_NUM + 95] * buffer[95] + 
          weight[out_idx * INPUT_NUM + 96] * buffer[96] + weight[out_idx * INPUT_NUM + 97] * buffer[97] + 
          weight[out_idx * INPUT_NUM + 98] * buffer[98] + weight[out_idx * INPUT_NUM + 99] * buffer[99] + 
          weight[out_idx * INPUT_NUM + 100] * buffer[100] + weight[out_idx * INPUT_NUM + 101] * buffer[101] + 
          weight[out_idx * INPUT_NUM + 102] * buffer[102] + weight[out_idx * INPUT_NUM + 103] * buffer[103] + 
          weight[out_idx * INPUT_NUM + 104] * buffer[104] + weight[out_idx * INPUT_NUM + 105] * buffer[105] + 
          weight[out_idx * INPUT_NUM + 106] * buffer[106] + weight[out_idx * INPUT_NUM + 107] * buffer[107] + 
          weight[out_idx * INPUT_NUM + 108] * buffer[108] + weight[out_idx * INPUT_NUM + 109] * buffer[109] + 
          weight[out_idx * INPUT_NUM + 110] * buffer[110] + weight[out_idx * INPUT_NUM + 111] * buffer[111] + 
          weight[out_idx * INPUT_NUM + 112] * buffer[112] + weight[out_idx * INPUT_NUM + 113] * buffer[113] + 
          weight[out_idx * INPUT_NUM + 114] * buffer[114] + weight[out_idx * INPUT_NUM + 115] * buffer[115] + 
          weight[out_idx * INPUT_NUM + 116] * buffer[116] + weight[out_idx * INPUT_NUM + 117] * buffer[117] + 
          weight[out_idx * INPUT_NUM + 118] * buffer[118] + weight[out_idx * INPUT_NUM + 119] * buffer[119] + 
          weight[out_idx * INPUT_NUM + 120] * buffer[120] + weight[out_idx * INPUT_NUM + 121] * buffer[121] + 
          weight[out_idx * INPUT_NUM + 122] * buffer[122] + weight[out_idx * INPUT_NUM + 123] * buffer[123] + 
          weight[out_idx * INPUT_NUM + 124] * buffer[124] + weight[out_idx * INPUT_NUM + 125] * buffer[125] + 
          weight[out_idx * INPUT_NUM + 126] * buffer[126] + weight[out_idx * INPUT_NUM + 127] * buffer[127] + 
          weight[out_idx * INPUT_NUM + 128] * buffer[128] + weight[out_idx * INPUT_NUM + 129] * buffer[129] + 
          weight[out_idx * INPUT_NUM + 130] * buffer[130] + weight[out_idx * INPUT_NUM + 131] * buffer[131] + 
          weight[out_idx * INPUT_NUM + 132] * buffer[132] + weight[out_idx * INPUT_NUM + 133] * buffer[133] + 
          weight[out_idx * INPUT_NUM + 134] * buffer[134] + weight[out_idx * INPUT_NUM + 135] * buffer[135] + 
          weight[out_idx * INPUT_NUM + 136] * buffer[136] + weight[out_idx * INPUT_NUM + 137] * buffer[137] + 
          weight[out_idx * INPUT_NUM + 138] * buffer[138] + weight[out_idx * INPUT_NUM + 139] * buffer[139] + 
          weight[out_idx * INPUT_NUM + 140] * buffer[140] + weight[out_idx * INPUT_NUM + 141] * buffer[141] + 
          weight[out_idx * INPUT_NUM + 142] * buffer[142] + weight[out_idx * INPUT_NUM + 143] * buffer[143] + 
          weight[out_idx * INPUT_NUM + 144] * buffer[144] + weight[out_idx * INPUT_NUM + 145] * buffer[145] + 
          weight[out_idx * INPUT_NUM + 146] * buffer[146] + weight[out_idx * INPUT_NUM + 147] * buffer[147] + 
          weight[out_idx * INPUT_NUM + 148] * buffer[148] + weight[out_idx * INPUT_NUM + 149] * buffer[149] + 
          weight[out_idx * INPUT_NUM + 150] * buffer[150] + weight[out_idx * INPUT_NUM + 151] * buffer[151] + 
          weight[out_idx * INPUT_NUM + 152] * buffer[152] + weight[out_idx * INPUT_NUM + 153] * buffer[153] + 
          weight[out_idx * INPUT_NUM + 154] * buffer[154] + weight[out_idx * INPUT_NUM + 155] * buffer[155] + 
          weight[out_idx * INPUT_NUM + 156] * buffer[156] + weight[out_idx * INPUT_NUM + 157] * buffer[157] + 
          weight[out_idx * INPUT_NUM + 158] * buffer[158] + weight[out_idx * INPUT_NUM + 159] * buffer[159] + 
          weight[out_idx * INPUT_NUM + 160] * buffer[160] + weight[out_idx * INPUT_NUM + 161] * buffer[161] + 
          weight[out_idx * INPUT_NUM + 162] * buffer[162] + weight[out_idx * INPUT_NUM + 163] * buffer[163] + 
          weight[out_idx * INPUT_NUM + 164] * buffer[164] + weight[out_idx * INPUT_NUM + 165] * buffer[165] + 
          weight[out_idx * INPUT_NUM + 166] * buffer[166] + weight[out_idx * INPUT_NUM + 167] * buffer[167] + 
          weight[out_idx * INPUT_NUM + 168] * buffer[168] + weight[out_idx * INPUT_NUM + 169] * buffer[169] + 
          weight[out_idx * INPUT_NUM + 170] * buffer[170] + weight[out_idx * INPUT_NUM + 171] * buffer[171] + 
          weight[out_idx * INPUT_NUM + 172] * buffer[172] + weight[out_idx * INPUT_NUM + 173] * buffer[173] + 
          weight[out_idx * INPUT_NUM + 174] * buffer[174] + weight[out_idx * INPUT_NUM + 175] * buffer[175] + 
          weight[out_idx * INPUT_NUM + 176] * buffer[176] + weight[out_idx * INPUT_NUM + 177] * buffer[177] + 
          weight[out_idx * INPUT_NUM + 178] * buffer[178] + weight[out_idx * INPUT_NUM + 179] * buffer[179] + 
          weight[out_idx * INPUT_NUM + 180] * buffer[180] + weight[out_idx * INPUT_NUM + 181] * buffer[181] + 
          weight[out_idx * INPUT_NUM + 182] * buffer[182] + weight[out_idx * INPUT_NUM + 183] * buffer[183] + 
          weight[out_idx * INPUT_NUM + 184] * buffer[184] + weight[out_idx * INPUT_NUM + 185] * buffer[185] + 
          weight[out_idx * INPUT_NUM + 186] * buffer[186] + weight[out_idx * INPUT_NUM + 187] * buffer[187] + 
          weight[out_idx * INPUT_NUM + 188] * buffer[188] + weight[out_idx * INPUT_NUM + 189] * buffer[189] + 
          weight[out_idx * INPUT_NUM + 190] * buffer[190] + weight[out_idx * INPUT_NUM + 191] * buffer[191] + 
          weight[out_idx * INPUT_NUM + 192] * buffer[192] + weight[out_idx * INPUT_NUM + 193] * buffer[193] + 
          weight[out_idx * INPUT_NUM + 194] * buffer[194] + weight[out_idx * INPUT_NUM + 195] * buffer[195] + 
          weight[out_idx * INPUT_NUM + 196] * buffer[196] + weight[out_idx * INPUT_NUM + 197] * buffer[197] + 
          weight[out_idx * INPUT_NUM + 198] * buffer[198] + weight[out_idx * INPUT_NUM + 199] * buffer[199] + 
          weight[out_idx * INPUT_NUM + 200] * buffer[200] + weight[out_idx * INPUT_NUM + 201] * buffer[201] + 
          weight[out_idx * INPUT_NUM + 202] * buffer[202] + weight[out_idx * INPUT_NUM + 203] * buffer[203] + 
          weight[out_idx * INPUT_NUM + 204] * buffer[204] + weight[out_idx * INPUT_NUM + 205] * buffer[205] + 
          weight[out_idx * INPUT_NUM + 206] * buffer[206] + weight[out_idx * INPUT_NUM + 207] * buffer[207] + 
          weight[out_idx * INPUT_NUM + 208] * buffer[208] + weight[out_idx * INPUT_NUM + 209] * buffer[209] + 
          weight[out_idx * INPUT_NUM + 210] * buffer[210] + weight[out_idx * INPUT_NUM + 211] * buffer[211] + 
          weight[out_idx * INPUT_NUM + 212] * buffer[212] + weight[out_idx * INPUT_NUM + 213] * buffer[213] + 
          weight[out_idx * INPUT_NUM + 214] * buffer[214] + weight[out_idx * INPUT_NUM + 215] * buffer[215] + 
          weight[out_idx * INPUT_NUM + 216] * buffer[216] + weight[out_idx * INPUT_NUM + 217] * buffer[217] + 
          weight[out_idx * INPUT_NUM + 218] * buffer[218] + weight[out_idx * INPUT_NUM + 219] * buffer[219] + 
          weight[out_idx * INPUT_NUM + 220] * buffer[220] + weight[out_idx * INPUT_NUM + 221] * buffer[221] + 
          weight[out_idx * INPUT_NUM + 222] * buffer[222] + weight[out_idx * INPUT_NUM + 223] * buffer[223] + 
  				exp_bias[out_idx];

 assign data_out = {calc_out[55],calc_out[38:16]}; // Shortened to 24 bits

 endmodule