import os
import pandas as pd

# 定义 float_to_fixed_point 函数
def float_to_fixed_point(inputValue):
    # 定义参数
    num_bits = 24
    sign_bit = 1
    int_bits = 7
    frac_bits = 16

    # 限定整数和小数位的最大范围
    max_int_value = (1 << int_bits) - 1
    min_int_value = -(1 << int_bits)
    max_frac_value = 1 << frac_bits

    # 提取符号
    sign = 0 if inputValue >= 0 else 1
    abs_value = abs(inputValue)

    # 将数值乘以 2**16
    fixed_value = int(round(abs_value * max_frac_value))

    # 获取整数和小数部分
    integer_part = fixed_value >> frac_bits
    fractional_part = fixed_value & (max_frac_value - 1)

    # 检查整数部分是否溢出
    if integer_part > max_int_value:
        raise ValueError(f"Integer part {integer_part} exceeds limit of {max_int_value}")

    # 创建二进制字符串
    binary_str = f"{sign:1b}{integer_part:05b}{fractional_part:010b}"

    # 将二进制字符串转换为24位整数
    fixed_point_value = int(binary_str, 2)

    # 转换为十六进制字符串
    hex_str = f"{fixed_point_value:06X}"

    # return inputValue
    return hex_str

# 创建目标文件夹
output_folder = "weightData"
if not os.path.exists(output_folder):
    os.makedirs(output_folder)
    
# 读取 Excel 文件
excel_file_path = 'model_parameters_16_32pooling.xlsx'


# 读取指定工作表
sheet_name = 'Layer_1_conv2d_1_Weights'

# 使用 pandas 读取特定工作表的 A 列到 H 列
df = pd.read_excel(excel_file_path, sheet_name=sheet_name, usecols='A:H', skiprows=0)

# 获取从第2行到第10行的所有值
values = df.iloc[0:9, :].values

# 对每个值执行 float_to_fixed_point 函数
fixed_point_values = [[float_to_fixed_point(value) for value in row] for row in values]

# 将结果保存为 .txt 文件
output_file_name = f"conv2d_weight.txt"
output_file_path = os.path.join(output_folder, output_file_name)
with open(output_file_path, 'w') as f:
    for row in fixed_point_values:
        f.write(' '.join(map(str, row)) + '\n')


# 读取指定工作表
sheet_name = 'Layer_1_conv2d_1_Biases'

# 使用 pandas 读取特定工作表的 A 列，从第二行开始到最后一行
df = pd.read_excel(excel_file_path, sheet_name=sheet_name, usecols='A', skiprows=0)

# 获取 A 列的值，转换为列表
values = df.iloc[:, 0].tolist()

# 对每个值执行 float_to_fixed_point 函数
fixed_point_values = [float_to_fixed_point(value) for value in values]

# 将结果保存为 .txt 文件
output_file_name = f"conv2d_bias.txt"
output_file_path = os.path.join(output_folder, output_file_name)
with open(output_file_path, 'w') as f:
    for value in fixed_point_values:
        f.write(f'{value}\n')


# 读取指定工作表
sheet_name = 'Layer_4_dense_1_Weights'

# 使用 pandas 读取特定工作表的 A 列，从第二行开始到最后一行
df = pd.read_excel(excel_file_path, sheet_name=sheet_name, usecols='A', skiprows=0)

# 获取 A 列的值，转换为列表
values = df.iloc[:, 0].tolist()

# 对每个值执行 float_to_fixed_point 函数
fixed_point_values = [float_to_fixed_point(value) for value in values]

# 将结果保存为 .txt 文件
output_file_name = f"fc_weight.txt"
output_file_path = os.path.join(output_folder, output_file_name)
with open(output_file_path, 'w') as f:
    for value in fixed_point_values:
        f.write(f'{value}\n')


# 读取指定工作表
sheet_name = 'Layer_4_dense_1_Biases'

# 使用 pandas 读取特定工作表的 A 列，从第二行开始到最后一行
df = pd.read_excel(excel_file_path, sheet_name=sheet_name, usecols='A', skiprows=0)

# 获取 A 列的值，转换为列表
values = df.iloc[:, 0].tolist()

# 对每个值执行 float_to_fixed_point 函数
fixed_point_values = [float_to_fixed_point(value) for value in values]

# 将结果保存为 .txt 文件
output_file_name = f"fc_bias.txt"
output_file_path = os.path.join(output_folder, output_file_name)
with open(output_file_path, 'w') as f:
    for value in fixed_point_values:
        f.write(f'{value}\n')

print(f'转换后的值已保存完毕')
