
//BLE
#include <Arduino.h>
#include <ArduinoBLE.h>
// FDC2214 
#include <Wire.h>
#include "FDC2214.h"

// Pressure Pin
#define PressurePin A0 
// Pressure level is between 0 and 3500 - tight pressure would be above 2500, mid pressure - around 1700
#define ZeroPressureLevel 200
#define MinPressureLevel 1400
#define MaxPressureLevel 2500

//#define Csensor 47 //in pF
//#define Lsensor 470 //in uH
// Setting up the capsence object 
FDC2214 capsense(FDC2214_I2C_ADDR_0); // Use FDC2214_I2C_ADDR_1 but then you need to connect ADDR to HIGH

// BLE UUIDs
const char* serviceUUID = "12345678-1234-1234-1234-1234567890AB";  // Custom Service UUID
const char* charUUID = "ABCD1234-5678-1234-5678-1234567890CD";     // Custom Characteristic UUID
//const char* serviceUUID = "F2704B4A-6932-4B6B-AD4D-4B9243C4B986";  // Even more Custom Service UUID
//const char* charUUID = "620404EE-4788-44D5-B85E-E220821B6C8B";     // Even more Custom Characteristic UUID

//BLE Service and characteristic setting up 
BLEService customService(serviceUUID);          // Create BLE Service
BLECharacteristic customChar(charUUID, BLERead | BLENotify,30); // Integer characteristic with Read and Notify properties, max number of bytes

int count = 0; // counter variable if needed
unsigned long previousMillis = 0;
const long interval = 500; // 0.5 second interval to increment the number

void setup() {
  Serial.begin(115200); // Initialize serial monitor
  delay(100);
  // while (!Serial); // Waits until serial monitor is opened
  Serial.println("Serial begin, initialize BLE...");
  // Initialize BLE
  if (!BLE.begin()) {
    Serial.println("Failed to initialize BLE!");
    while (1);
  }
  // Set BLE device name and add the service
  BLE.setLocalName("Skin Capacitance System");
  BLE.setAdvertisedService(customService);
  // Add characteristic to the service
  customService.addCharacteristic(customChar);
  // Add service
  BLE.addService(customService);
  // Start advertising
  BLE.advertise();
  Serial.println("BLE device is now advertising...");

  // Start the FDC
  // Start FDC2214 with 4 channels init
  bool capOk = capsense.begin(0xF, 0x6, 0x5, false); //setup all four channels, autoscan with 4 channels, deglitch at 10MHz, external oscillator 
 // Start FDC2214 with 4 channels init
 // bool capOk = capsense.begin(0xF, 0x6, 0x5, true); //setup all four channels, autoscan with 4 channels, deglitch at 10MHz, internal oscillator 
  if (capOk) Serial.println("Sensor OK");  
  else Serial.println("Sensor Fail");  
  delay (1000);
  // randomSeed(12345);
}

void loop() {
  
  unsigned long cap;
  
  // Handle BLE client connections
  BLEDevice central = BLE.central();

  if (central) {
    Serial.print("Connected to central: ");
    Serial.println(central.address());

    // Keep transmitting the incrementing number while connected
    while (central.connected()) {
      
      analogReadResolution(12);
      int pressure = analogRead(PressurePin);
      unsigned long cap = capsense.getReading28(0);
      // long pressure = random(10,3500);
      // unsigned long cap = random(5000000,6000000);

      unsigned long currentMillis = millis();

      // Increment the counter every 1 second
      if (currentMillis - previousMillis >= interval) {
        previousMillis = currentMillis;
        

        if (pressure <= ZeroPressureLevel) {
          count = 0; //resetting count so that you get 30 sequential readings. 
          Serial.print("No_Contact");
          Serial.print(",");
          Serial.print(pressure);
          Serial.print(",");
          Serial.println(cap);

          String message = "NoContact," + String(pressure) + "," + String(cap);
          customChar.writeValue(message.c_str());  // Update the BLE characteristic with the new value            
        } 

        if (pressure > ZeroPressureLevel && pressure <= MinPressureLevel) {
          count = 0; //resetting count so that you get 30 sequential readings. 
          Serial.print("Low_Pressure");
          Serial.print(",");
          Serial.print(pressure);
          Serial.print(",");
          Serial.println(cap);

          String message = "LowPressure," + String(pressure) + "," + String(cap);
          customChar.writeValue(message.c_str());  // Update the BLE characteristic with the new value          
        } 
  
        if (pressure > MinPressureLevel && pressure <= MaxPressureLevel){
          count += 1;
          Serial.print("Great_Contact");
          Serial.print(",");
          Serial.print(pressure);
          Serial.print(",");
          Serial.println(cap);

          String message = "GoodPressure," + String(pressure) + "," + String(cap);
          customChar.writeValue(message.c_str());  // Update the BLE characteristic with the new value
      
          if (count == 30) {
            Serial.println("30 readings! Remove sensor");
            String message = "30 readings! Remove sensor";
            customChar.writeValue(message.c_str()); 
            delay(5000);
            count = 0;
          }
        }
        if (pressure > MaxPressureLevel){
          count = 0; //resetting count so that you get 30 sequential readings. 
          Serial.print("Too_Much_Pressure");
          Serial.print(",");
          Serial.print(pressure);
          Serial.print(",");
          Serial.println(cap);

          String message = "HighPressure," + String(pressure) + "," + String(cap);
          customChar.writeValue(message.c_str());  // Update the BLE characteristic with the new value
        }

        // customChar.writeValue((byte) count);
        // count++;
        // Serial.print("Sent pressure and capa value like this: ");
        // Serial.println(message);
      }
    }

    Serial.print("Disconnected from central: ");
    Serial.println(central.address());
  }
  else {
    Serial.println("not connected, waiting");
    delay(1000);
  }
}