import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
from cycler import cycler
from scipy.stats import pearsonr
from sklearn.metrics import roc_curve, roc_auc_score

plt.rcParams.update({
    'font.size': 14,  # Default font size for all text
    'font.weight': 'bold',  # Make all text bold
    'font.style': 'normal',  # Set font style to italic
    'font.family': 'Arial',  # Set default font family (you can change to 'sans-serif', 'monospace', etc.)
    'axes.titlesize': 18,  # Title font size
    'axes.titleweight': 'bold',  # Title font weight
    'axes.labelsize': 16,  # X and Y labels font size
    'axes.labelweight': 'bold',  # X and Y labels font weight
    # Added the Origin Pro colors from their built-in palette -
    # gray, red, blue, green,
    # purple, ochre, cyan, brown,
    # olive, orange, sky-blue
    'axes.prop_cycle': cycler('color', ['#515151', '#f14040', '#1a6fdf', '#37ad6b',
                                        '#b177de', '#cc9900', '#00cbcc', '#7d4e4e',
                                        '#8e8e00', '#fb6501', '#6699cc'])
})

def calculate_statistics(data):
    medians = []
    stddevs = []
    patients = []
    for patient, values in data.items():
        medians.append(np.median(values))
        stddevs.append(np.std(values))
        patients.append(patient)
    return patients, medians, stddevs

lesional_TEWL = pd.read_csv('lesional_TEWL.csv').iloc[:, 1:].to_dict(orient='list')
nonlesional_TEWL = pd.read_csv('nonlesional_TEWL.csv').iloc[:, 1:].to_dict(orient='list')

# Clean NaN values with one-liner
lesional_TEWL = {k: [v for v in vals if pd.notna(v)] for k, vals in lesional_TEWL.items()}
nonlesional_TEWL = {k: [v for v in vals if pd.notna(v)] for k, vals in nonlesional_TEWL.items()}

lesional_patients, lesional_medians, lesional_stddevs = calculate_statistics(lesional_TEWL)
nonlesional_patients, nonlesional_medians, nonlesional_stddevs = calculate_statistics(nonlesional_TEWL)

# Scatter plot with error bars
plt.figure(figsize=(10, 6))
plt.errorbar(lesional_patients, lesional_medians, yerr=lesional_stddevs, fmt='o', label='Lesional', capsize=5)
plt.errorbar(nonlesional_patients, nonlesional_medians, yerr=nonlesional_stddevs, fmt='o', label='Non-Lesional', capsize=5)

# Customize plot
plt.xlabel('Patients Number')
# plt.xlabel('Patients Number ID')
plt.ylabel('Median TEWL (g/m$^2$h)')
plt.title('TEWL Values: Lesional vs Non-Lesional Skin of Patients ')
# plt.xticks(range(len(lesional_patients)), range(1, len(lesional_patients) + 1))
matched_patients = ['1','8','9','10','11','12','13']
plt.xticks(ticks = range(len(matched_patients)), labels = matched_patients)
# plt.xticks(rotation=45)
plt.grid(True, linestyle='--', alpha=0.7)
plt.legend()
plt.tight_layout()
# plt.savefig('tewlLvsNL_allPat.pdf', format='pdf')

plt.show()
